import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;


public class Herm
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;
  private JButton startButton, space;  // button objects
  private JTextField pointX0, nDegree, xValues, dfxValues, fxValues, exprField,exprField2;
  private JTextArea solution;
  private double x0, p, S;
  private int I, J, K, n; 
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;

  private double q[][], x[], xx[], z[], temp[], temp2[];

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {

                x0 = Double.parseDouble(pointX0.getText());
                 n = Integer.parseInt(nDegree.getText());
                OK  = true;
                    q = new double[26][26]; 
                    z = new double[26];
                    xx = new double[26];
                    x = new double[26];
                    toArray(xValues.getText(), x); //convert values in text field into array elements
        
            solution.setText("");            

           if(inputCheck())
             {
              if(fxValues.getText()== null || fxValues.getText().equals("")) //no values entered for function
                 {

                    for(I = 0; I <= n ; I++)
                       {
                        q[2*I][0] = functnF(x[I]);
                        q[2*I+1][1] = functnFP(x[I]);
                       } 
                 }
                 else
                  {                            //values has been entered for f(x)
                    temp = new double[26];                  
                    temp2 = new double[26];                  
                    toArray(fxValues.getText(), temp);
                    toArray(dfxValues.getText(), temp2);

                    for(I=0; I<=n; I++){q[2*I][0] = temp[I];}
                    for(I=0; I<=n; I++){q[2*I+1][1] = temp2[I];}

                  }
               for(I=0; I<=n; I++)
                  {
                   z[2*I] = x[I];
                   z[2*I+1] = x[I]; 
                   q[2*I+1][0] = q[2*I][0];

                   if( I!= 0){
                     q[2*I][1] = (q[2*I][0] - q[2*I-1][0])/(z[2*I]-z[2*I-1]);}
                    }

                   K =2*n +1;
               for(I=2; I<=K; I++)
                    {
                     for(J = 2; J <= I; J++)
                        {
                         q[I][J] = (q[I][J-1] - q[I-1][J-1])/(z[I] - z[I-J]);
                         } 
                      }
                calculateP();
                outPut();
               }

            }

      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
public String[] StringtoArray( String s, String sep ) {
    // convert a String s to an Array, the elements
    // are delimited by sep
    StringBuffer buf = new StringBuffer(s);
    int arraysize = 1;
    for ( int i = 0; i < buf.length(); i++ ) {
      if ( sep.indexOf(buf.charAt(i) ) != -1 )
        arraysize++;
    }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************
  public void calculateP()
  {
        S = q[K][K]*(x0 -z[K-1]);
  
    for(I=2; I<=K; I++)
       {

        J = K - I +1;
        S = (S + q[J][J])*(x0 -z[J -1]);
       }
       S = S +q[0][0]; 
  } 

  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i=0;i<charArray.length; ++i)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }

     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point)
   {
    double f;
    xValue = point;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   f = (x + 4.0)*x^2 - 10.0;
    return f;
   }

  public double functnFP(double point)
   {
    double fp;
    xValue = point;  
    parseExp(exprField2.getText());
    fp = myParser.getValue();  // example   f = (x + 4.0)*x^2 - 10.0;
    return fp;
   }

  public boolean inputCheck()
   {
        String errorInfo;
          if (n <= 0 ){
            solution.append("Degree must be a positive integer. \n");
            OK = false;}
          if(fxValues.getText()== null || fxValues.getText().equals("")){ 
            parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
            parseExp(exprField2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}}
          return OK;

   }     

  public void outPut()
      {
       for(I = 0; I<=n; I++){ xx[2*I] = x[I]; xx[2*I+1] = x[I] ;}

         solution.append(" "+"i\t"+"x\t"); 
         for(I=0; I<=K; I++)
            { 
             if(I==0){solution.append(""+"q[Xi]\t");}else{solution.append(""+"q[Xi-"+I+",..,Xi]\t");} 
            }
            solution.append("\n"); 
            for(I=0; I<=K; I++)
               {
                solution.append(" "+I+"\t"+formatter.format(xx[I])+"\t"); 
                 for(J = 0; J <= I; J++){ solution.append(formatter.format(q[I][J])+"\t");} 
                solution.append("\n"); 
                }
           solution.append("\nCoefficients are Q[0,0], ... ,Q[n,n] \n");
           solution.append("  "); 
           for(I = 0; I<=K ; I++) solution.append(formatter.format(q[I][I])+"\t");
                
                solution.append("\n\n");
                solution.append(" "+"H("+x0+")= "+formatter.format(S)); 
      } 

  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    xValues = new JTextField("1.3, 1.6, 1.9");
    fxValues= new JTextField("0.6200860, 0.4554022, 0.2818186");
    dfxValues= new JTextField("-0.5220232, -0.5698959, -0.5811571");
    pointX0 = new JTextField(4);
    exprField = new JTextField("1/x");
    exprField2 = new JTextField("-1/x^2");
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel1 = new JPanel(new GridLayout(2,6));

    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel1.add(new JLabel("Xo, X1, X2,..,Xn:", JLabel.RIGHT));
    inputPanel1.add(xValues);
    inputPanel1.add(new JLabel("n =:", JLabel.RIGHT));
    inputPanel1.add(nDegree);
    inputPanel1.add(new JLabel("point x =:", JLabel.RIGHT));
    inputPanel1.add(pointX0);

    JPanel inputPanel2 = new JPanel(new GridLayout(7,2));

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel2.add(new JLabel("f(x) =:", JLabel.RIGHT));
    inputPanel2.add(exprField);
    inputPanel2.add(new JLabel("f '(x) =:", JLabel.RIGHT));
    inputPanel2.add(exprField2);

    inputPanel2.add(new JLabel("OR         ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel2.add(new JLabel("f(x) values =:", JLabel.RIGHT));
    inputPanel2.add(fxValues);
    inputPanel2.add(new JLabel("f '(x) values =:", JLabel.RIGHT));
    inputPanel2.add(dfxValues);


    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel1, "North");
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(7);
    formatter.setMinimumFractionDigits(7);
  }

 
  }
    
   
