import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class GSca
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField nDegree, exprField;
  private JTextArea solution;
  private int N, M, I, J, ICHG, NN, IMAX, IP, JP, NCOPY, I1, J1, N1, N2, LL, JJ, K, L, KK; 
  private int NROW[];
  private boolean OK, inputCancel;
  private NumberFormat formatter;
  private double AMAX, XM, SUM, TEMP, A[][], X[], S[];
  

  public void init() {
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[10][11]; X = new double[10]; NROW = new int[10];
                S = new double[10];
                N = Integer.parseInt(nDegree.getText());
               OK = true;
    
              arrayInput(A, exprField.getText());
                 

            solution.setText("");            

           if(inputCheck())
             {      
      M = N + 1;
      /* STEP 1 */
      for (I=1; I<=N; I++) {
         S[I-1] = Math.abs(A[I-1][0]);
         /* initialize row pointer */
         NROW[I-1] = I;
         for (J=1; J<=N; J++) 
            if (Math.abs(A[I-1][J-1] ) > S[I-1])
               S[I-1] = Math.abs(A[I-1][J-1]);
         if (S[I-1] <= 0) OK = false;
      }  
      NN = N - 1;
      ICHG = 0;
      I = 1;
      /* STEP 2 */
      /* elimination process */
      while (OK && (I <= NN)) {
         /* STEP 3 */
         IMAX = NROW[I-1];
         AMAX = Math.abs(A[IMAX-1][I-1]) / S[IMAX-1];
         IMAX = I;
         JJ = I + 1;
         for (IP=JJ; IP<=N; IP++) {
            JP = NROW[IP-1];
            TEMP = Math.abs(A[JP-1][I-1]/S[JP-1]);
            if (TEMP > AMAX ) {
               AMAX = TEMP;
               IMAX = IP;
            }  
         }  
         /* STEP 4 */
         /* system has no unique solution */
         if (AMAX <= 0) OK = false;
         else {
            /* STEP 5 */
            /* simulate row interchange */
            if (NROW[I-1] != NROW[IMAX-1]) {
               ICHG = ICHG + 1;
               NCOPY = NROW[I-1];
               NROW[I-1] = NROW[IMAX-1];
               NROW[IMAX-1] = NCOPY;
            }
            /* STEP 6 */
            I1 = NROW[I-1];
            for (J=JJ; J<=N; J++) {
               J1 = NROW[J-1];
               /* STEP 7 */
               XM = A[J1-1][I-1] / A[I1-1][I-1];
               /* STEP 8 */
               for (K=JJ; K<=M; K++) 
                   A[J1-1][K-1] = A[J1-1][K-1] - XM * A[I1-1][K-1];
               /* Multiplier XM could be saved in A[J1-1][I-1] */
               A[J1-1][I-1] = 0.0;
            }  
         }  
         I++;
      }
      if (OK) {
         /* STEP 9 */
         N1 = NROW[N-1];
         if (Math.abs(A[N1-1][N-1] ) <= 0) OK = false;
         /* system has no unique solution */
         else {
            /* STEP 10 */
            /* start backward substitution */
            X[N-1] = A[N1-1][M-1] / A[N1-1][N-1];
            /* STEP 11 */
            for (K=1; K<=NN; K++) {
               I = NN - K + 1;
               JJ = I + 1;
               N2 = NROW[I-1];
               SUM = 0.0;
               for (KK=JJ; KK<=N; KK++) {
                  SUM = SUM - A[N2-1][KK-1] * X[KK-1];
               }
               X[I-1] = (A[N2-1][N] + SUM) / A[N2-1][I-1];
            }  
            /* STEP 12 */
            /* procedure completed successfully */
            outPut(N, M, ICHG, NROW, X, A);
         }  
      }  
        if (!OK) solution.append("System has no unique solution\n");
      }
}


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************

   public void outPut(int N, int M, int ICHG,int NROW[], double X[], double A[][])
       {
        int I, J;

        solution.append("Gaussian Elimination- Scaled Partial Pivoting\n\n");
        solution.append("The reduced system - output by rows:\n");
        for (I=1; I<=N; I++) {
          for (J=1; J<=M; J++) solution.append(""+formatter.format(A[I-1][J-1])+"    ");
          solution.append("\n");
         }
     solution.append("\n\nHas solution vector:\n");
     for (I=1; I<=N; I++) solution.append(""+formatter.format(X[I-1])+"    ");
     solution.append("\n\nwith "+ICHG+" row interchange(s)\n");
   
     solution.append("\nThe rows have been logically re-ordered ro:\n");
     for (I=1; I<=N; I++) solution.append(""+NROW[I-1]+"    ");
    }

  public void arrayInput(double arr[][], String str){
      int m = N+1;
     try{
         
      String[] charArray = StringtoArray(str,","); 
      for(int i = 0; i< N; i++){
  
        for(int j=0;j<=N; ++j)
             arr[i][j] = Double.parseDouble(charArray[m*i +j]);
       }
      }
   catch(NumberFormatException ex){ inputCancel= true; }       
  }



  public boolean inputCheck()
   {
        String errorInfo;
          if (N <= 0 ){
            solution.append("Order must be a positive integer. \n");
          OK = false;}
        if (inputCancel){
            solution.append("Values must be entered for matrix. \n");
          OK = false;}
          return OK;

   }     



  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    exprField = new JTextField(40);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(2,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Equations N =:", JLabel.RIGHT));
    inputPanel.add(nDegree);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel inputPanel2 = new JPanel(new GridLayout(2,2));

    inputPanel2.add(new JLabel("Matrix in row form. Separate elements with commas \",\" A =:", JLabel.RIGHT));
    inputPanel2.add(exprField); exprField.setText("1,-1,2,-1,-8,2,-2,3,-3,-20,1,1,1,0,-2,1,-1,4,3,4");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(4);
    formatter.setMinimumFractionDigits(4);
  }


  }
    
   
