import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;


public class FFT
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;
  private JButton startButton, space;  // button objects
  private JTextField mDegree, xValues, fxValues, exprField;
  private JTextArea solution;
  private double WWR, WWI, T1R, T1I, T3R, T3I, Z, XR, XI, YR, YI, TW, CM1, CM2,CP1, CP2, md ; 
  private int  NG, M1, NU1, N, N2, I, K, L, M, NP, J; 
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;

  private double CR[], CI[], WR[], WI[], Y[], xx[], temp[];

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                CR = new double[64]; CI = new double[64]; WR = new double[64]; 
                WI = new double[64]; Y = new double[64];
                 M = Integer.parseInt(mDegree.getText());
                 N = 2*M;
                OK  = true;
 
            solution.setText("");            

           if(inputCheck())
             {
               solution.append("Fast Fourier Transform\n\n");
              if(fxValues.getText()== null || fxValues.getText().equals("")) //function entered instead of values
                 {
                    md = M;

                    for(I = 1; I <= N ; I++){Z = -Math.PI+(I - 1)*Math.PI/md ;Y[I-1] = functnF(Z);} 
                 }
                 else
                  {                            //values has been entered for f(x)
                   temp = new double[64];                  
                     toArray(fxValues.getText(), temp);
                    for(I=1; I <= N; I++){Y[I-1] = temp[I-1];}
                  }
 
       TW = Math.log(2.0);
      /* STEP 1 */
      /* use N2 for m, NG for p, NU1 for q, WW for zeta */
      N2 = N / 2;
      /* STEP 2 */
      for (I=1; I<=N; I++) {
         CR[I-1] = Y[I-1];
         CI[I-1] = 0.0;
      }  
      Z = N;
      NG = (int)(Math.log(Z)/TW+.5);
      NU1 = NG - 1;
      YR = 0.0;
      YI = 2.0*Math.PI/N;
      CEXP(YR,YI); WWR = CP1; WWI = CP2;
      /* STEP 3 */
      for (I=1; I<=N2; I++) {
         XR = 1.0;
         XI = 0.0;
         YR = 1.0;
         YI = 0.0;
         for (J=1; J<=I; J++) {
            CMULT(XR,XI,WWR,WWI); YR = CM1; YI= CM2;
            XR = YR;
            XI = YI;
         }
         WR[I-1] = XR;
         WI[I-1] = XI;
         WR[N2+I-1] = -XR;
         WI[N2+I-1] = -XI;
      }  
      /* STEP 4 */
      K = 0;
      /* STEP 5 */
      for (L=1; L<=NG; L++) {
         /* STEP 6 */
         while (K < N-1) {
            /* STEP 7 */
            for (I=1; I<=N2; I++) {
               /* STEP 8 */
               Z = Math.exp(NU1*TW);
               M1 = (int)(Z+.5);
               M1 = K/M1;
               /* IBR does the bit reversal */
               NP = IBR(M1,NG);
               /* T1 = T1R + T1i is eta */
               T1R = CR[K+N2];
               T1I = CI[K+N2];
               /* STEP 9 */
               if (NP != 0) {
                  XR = T1R;
                  XI = T1I;
                  CMULT(XR,XI,WR[NP-1],WI[NP-1]); T1R = CM1; T1I = CM2;
               }  
               CR[K+N2] = CR[K] - T1R;
               CI[K+N2] = CI[K] - T1I;
               CR[K] = CR[K] + T1R;
               CI[K] = CI[K] + T1I;
               /* STEP 10 */
               K++;
            }  
            /* STEP 11 */
            K = K+N2;
         }  
         /* STEP 12 */
         K = 0;
         N2 = N2/2;
         NU1--;
      }  
      /* STEP 13 */
      while (K < N-1) {
         /* STEP 14 */
         I = IBR(K,NG);
         /* STEP 15 */
         if (I > K) {
            T3R = CR[K];
            CR[K] = CR[I];
            CR[I] = T3R;
            T3I = CI[K];
            CI[K] = CI[I];
            CI[I] = T3I;
         }  
         /* STEP 16 */
         K++;
      }  
      /* STEPS 17 and 18 */
      solution.append("Coefficients c(0), ... , c(2m-1)\n\n");
      for (I=1; I<=N; I++) {
         YR = 0.0;
         YI = -(I-1)*Math.PI;
         CEXP(YR,YI); XR = CP1; XI = CP2;
         CMULT(XR,XI,CR[I-1],CI[I-1]); YR = CM1; YI = CM2;
         CR[I-1] = YR/(0.5*N);
         CI[I-1] = YI/(0.5*N);
         K = I - 1;

         solution.append("  "+K+PadWithBlanks(""+formatter.format(CR[I-1]),20)+PadWithBlanks(""+formatter.                         format(CI[I-1]),20)+"\n");
      }  
      solution.append("\nCoefficients a(0), ..., a(m)\n\n");
      for (I=1; I<=M+1; I++) solution.append(PadWithBlanks(""+formatter.format( CR[I-1]),20)+"\n");
      solution.append( "\nCoefficients b(1), ..., b(m-1)\n\n");
      for (I=2; I<=M; I++) solution.append(PadWithBlanks(""+formatter.format(CI[I-1]),20)+"\n");

          }
        }

      //}

      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }

public String PadWithBlanks(String numAsString, int width)
      {
       int blanksToPad = width - numAsString.length();
       for(int j = 1; j <= blanksToPad; j++)
           numAsString = " " + numAsString ;
       return numAsString;
      }

public void CMULT(double A, double B, double C, double D)
/*  Performs complex multiplication:
       (A + Bi) * (C + Di) -> E + Fi         */
{
   double A1, B1, C1, D1;

   if (Math.abs(A) <= 0) A1 = 0.0;
   else A1 = A;
   if (Math.abs(B) <= 0) B1 = 0.0;
   else B1 = B; 
   if (Math.abs(C) <= 0) C1 = 0.0;
   else C1 = C;
   if (Math.abs(D) <= 0) D1 = 0.0;
   else D1 = D;
   CM1 = (A1*C1) - (B1*D1);
   CM2 = A1*D1 + B1*C1;
}

public void CEXP(double A, double B)
/*  Performs complex exponentiation:
       exp(A + Bi) -> C + Di      */
{
   double E;

   E = Math.exp(A);
   CP1 = E * Math.cos(B);
   CP2 = E * Math.sin(B);
}

public int IBR(int J, int NU)
{
   int K, I, J2, J1;

   J1 = J;
   K = 0;
   for (I=1; I<=NU; I++) {
      J2 = J1 / 2;
      K = 2*K+(J1-2*J2);
      J1 = J2;
   }
   return K; 
}

//****************************************************************
public String[] StringtoArray( String s, String sep ) {
    // convert a String s to an Array, the elements
    // are delimited by sep
    StringBuffer buf = new StringBuffer(s);
    int arraysize = 1;
    for ( int i = 0; i < buf.length(); i++ ) {
      if ( sep.indexOf(buf.charAt(i) ) != -1 )
        arraysize++;
    }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************


  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i=0;i<charArray.length; ++i)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }

     public void parseExpression() {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
		myParser.parseExpression(exprField.getText());
	}


  public double functnF(double point)
   {
    double f;
    xValue = point;  
    parseExpression();
    f = myParser.getValue();  // example   f = (x + 4.0)*x^2 - 10.0;
    return f;
   }

  public boolean inputCheck()
   {
        String errorInfo;
          if (M <= 0 ){
            solution.append("Number must be a positive integer. \n");
            OK = false;}
          if(fxValues.getText()== null || fxValues.getText().equals("")){ 
            parseExpression();
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}}
          return OK;

   }     



  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    mDegree = new JTextField(2);
    fxValues= new JTextField("-19.7392088022, -7.40220330082, 0.0, 2.46740110027");
    exprField = new JTextField("x*cos(x^2) + e^x*cos(e^x)");
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel1 = new JPanel(new GridLayout(2,6));

    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("m =:", JLabel.RIGHT));
    inputPanel1.add(mDegree);
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));

    JPanel inputPanel2 = new JPanel(new GridLayout(4,2));
    inputPanel2.add(new JLabel("function f(x) =:", JLabel.RIGHT));
    inputPanel2.add(exprField);

    inputPanel2.add(new JLabel("OR         ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel2.add(new JLabel("f(x) values =:", JLabel.RIGHT));
    inputPanel2.add(fxValues);

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel1, "North");
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(8);
    formatter.setMinimumFractionDigits(8);
  }


  }
    
   
