
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Extra
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, AlphaCondn, stepHmax, stepHmin, Tolerance, exprField;
  private JTextArea solution;
  private double A, B, Tol, Alpha, Hmax, Hmin, H, HK, W0, W1, W2, W3, T, T0, V;
  private double Q[][], Y[];
  private int I, J, K, P, KK, N, M, NFlag, NK[];
  private boolean OK, Done;
  private NumberFormat formatter;
  private double yValue, tValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 Q = new double[7][7]; Y = new double[9]; NK = new int[8];
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 Hmax = Double.parseDouble(stepHmax.getText());
                 Hmin = Double.parseDouble(stepHmin.getText());
                 Alpha = Double.parseDouble(AlphaCondn.getText());
                 Tol = Double.parseDouble(Tolerance.getText());


                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
                solution.append(" "+" T\tW\tH\tK\n");
     /* STEP 2 */
      NK[0] = 2;
      NK[1] = 4;
      for (J=1; J<=3; J++) {
         I = 2*J;
         NK[I] = 3 * NK[I-1] / 2;
         NK[I+1] = 2 * NK[I-1];
      }
      /* STEP 2 */
      T0 = A;
      W0 = Alpha;
      H = Hmax;
      /*  Done is used in place of FLAG to exit the loop in Step 4  */
      Done = false;
      /* STEP 3 */
      for (I=1; I<=7; I++)
         for (J=1; J<=I; J++)
            Q[I-1][J-1] = (NK[I] * 1.0 / NK[J-1])*(NK[I] * 1.0 / NK[J-1]);
      /* STEP 4 */
      while (!Done) {
         /* STEP 5 */
         K = 1;
         /* when desired accuracy achieved, NFlag is set to 1 */
         NFlag = 0;
         /* STEP 6 */
         while ((K <= 8) && (NFlag == 0)) {
            /* STEP 7 */
            HK = H / NK[K-1];
            T = T0;
            W2 = W0;
            /* Euler first step */
            W3 = W2 + HK * functnF(T, W2);
            T = T0 + HK;
            /* STEP 8 */
            M = NK[K-1] - 1;
            for (J=1; J<=M; J++) {
               W1 = W2;
               W2 = W3;
               /* midpoint method */
               W3 = W1 + 2.0 * HK * functnF(T, W2);
               T = T0 + (J + 1) * HK;
            }  
            /* STEP 9 */
            /* endpoint correction to compute Y(K,1) */
            Y[K] = (W3 + W2 + HK * functnF(T, W3)) / 2.0;
            /* STEP 10 */
            /* NOTE: Y(K-1)=Y(K-1,1),Y(K-2)=Y(K-1,2),..., */
            /* Y(1)=Y(K-1,K-1) since only previous row of table */
            /* is saved  */
            if (K >= 2) {
               /* STEP 11 */
               J = K;
               /*  save Y(K-1,K-1)  */
               V = Y[1];
               /* STEP 12 */
               while (J >= 2) {
                  /* extrapolation to compute */ 
                  /* Y(J-1) = Y(K,K-J+2) */
                  Y[J-1] = Y[J] + ( Y[J] - Y[J-1] ) /
                           ( Q[K-2][J-2] - 1.0 );
                  J--;
               }  
               /* STEP 13 */
               if (Math.abs(Y[1] - V) <= Tol) NFlag = 1;
               /* Y(1) accepted as new w */
            }  
            /* STEP 14 */
            K++;
         }
         /* STEP 15 */
         K--;
         /* STEP 16 */
         if (NFlag == 0) {
            /* STEP 17 */
            /* new value for w rejected, decrease H */
            H = H / 2.0;
            /* STEP 18 */
            if (H < Hmin) {
               solution.append("Hmin exceeded\n");
               Done = true;
            }  
         }  
         else {
            /* STEP 19 */
            /* new value for w accepted */
            W0 = Y[1];
            T0 = T0 + H;
solution.append(" "+formatter.format(T0)+"\t"+formatter.format(W0)+"\t"+formatter.format(H)                   +"\t"+formatter.format(K)+"\n");
            /* STEP 20 */
            /* increase H if possible */
            if (T0 >= B) Done = true;
            else if (T0 + H > B) H = B - T0;
            else if (K <= 3) H = 2.0 * H;
            if (H > Hmax) H = H / 2.0;
         }
      }     
                   
          }
        }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
              
 

     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("t", tValue);
		myParser.addVariable("y", yValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2)
   {
    double f;
    tValue = point1;
    yValue = point2;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  

    public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (Tol <=0){
            solution.append("Tolerance must be positive \n");
            OK = false;}

          if (Hmin > Hmax){
            solution.append("Minimum mesh must be less than the maximum mesh spacing\n");
            OK = false;}

          if ((Hmin <=0) || (Hmax <= 0)){
            solution.append("Both Minimum and Maximum mesh spacing must be a positive real \n");
            OK = false;}


          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     
 

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    AlphaCondn = new JTextField(4);
    stepHmax = new JTextField(2);
    stepHmin = new JTextField(2);
    Tolerance = new JTextField(4);
    exprField = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function f(t,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("y - t^2 + 1");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("Condition Alpha =:", JLabel.RIGHT));
    inputPanel.add(AlphaCondn);


    inputPanel.add(new JLabel("Hmin =:", JLabel.RIGHT));
    inputPanel.add(stepHmin);
    inputPanel.add(new JLabel("Hmax =:", JLabel.RIGHT));
    inputPanel.add(stepHmax);
    inputPanel.add(new JLabel("Tolerance =:", JLabel.RIGHT));
    inputPanel.add(Tolerance);

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
