import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class DirectF
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField nDegree, iswField, exprField;
  private JTextArea solution;
  private int M, N, I, J, K, NN, JJ, KK, ISW; 
  private boolean OK, inputCancel;
  private NumberFormat formatter;
  private double A[][], XL[], S, SS;
  

  public void init() {

    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[10][10]; XL = new double[10];
                N = Integer.parseInt(nDegree.getText());
                ISW = Integer.parseInt(iswField.getText());
                OK = true;
    
              arrayInput(A, exprField.getText());
          

           if(inputCheck())
             {
            solution.setText("");       
      for (I=1; I<=N; I++) XL[I-1] = 1.0;
      /* STEP 1 */
      if (Math.abs(A[0][0]) <= 0) OK = false;
      else {
         /* the entries of L below the main diagonal will be
            placed in the corresponding entries of A; the
            entries of U above the main diagonal will be
            placed in the corresponding entries of A; the
            main diagonal which was NOT input will become
            the main diagonal of A; the input main diagonal
            of L or U is, of course, placed in XL.           */
         A[0][0] = A[0][0] / XL[0];
         /* STEP 2 */
         for (J=2; J<=N; J++) {
            if (ISW == 0) {
               /* first row of U */
               A[0][J-1] = A[0][J-1] / XL[0];
               /* first column of L */
               A[J-1][0] = A[J-1][0] / A[0][0];
            }
            else {
               /* first row of U */
               A[0][J-1] = A[0][J-1] / A[0][0];
               /* first column of L */
               A[J-1][0] = A[J-1][0] / XL[0];
            }
         }
         /* STEP 3 */
         M = N - 1;
         I = 2;
         while ((I <= M) && OK) {
            /* STEP 4 */
            KK = I - 1;
            S = 0.0;
            for (K=1; K<=KK; K++) S = S - A[I-1][K-1] * A[K-1][I-1];
            A[I-1][I-1] = ( A[I-1][I-1] + S ) / XL[I-1];
            if (Math.abs(A[I-1][I-1]) <= 0) OK = false;
            else { 
               /* STEP 5 */
               JJ = I + 1;
               for (J=JJ; J<=N; J++) {
                  SS = 0.0;
                  S = 0.0;
                  for (K=1; K<=KK; K++) {
                     SS = SS - A[I-1][K-1] * A[K-1][J-1];
                     S = S - A[J-1][K-1] * A[K-1][I-1];
                  }  
                  if (ISW == 0) {
                     /* Ith row of U */
                     A[I-1][J-1] = (A[I-1][J-1] + SS) / XL[I-1];
                     /* Ith column of L */
                     A[J-1][I-1] = (A[J-1][I-1] + S) / A[I-1][I-1];
                  }
                  else {
                     /* Ith row of U */
                     A[I-1][J-1] = (A[I-1][J-1] + SS) / A[I-1][I-1];
                     /* Ith column of L */
                     A[J-1][I-1] = (A[J-1][I-1] + S) / XL[I-1];
                  }  
               }  
            }  
            I++;
         }  
         if (OK) {
            /* STEP 6 */
            S = 0.0;
            for (K=1; K<=M; K++)  S = S - A[N-1][K-1] * A[K-1][N-1];
            A[N-1][N-1] = (A[N-1][N-1] + S) / XL[N-1];
            /* If A(N-1,N-1) = 0 then A = LU but the matrix is singular.
               Process is complete, all entries of A have been
               determined. */
            /* STEP 7 */
            outPut(N, A, ISW);
         }  
      }  
      if (!OK) solution.append("System has no unique solution");
        

      }
}


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************

   public void outPut(int N, double A[][], int ISW)
       {
        int I, J;

        solution.append("General LU Factorization\n\n");
        if(ISW == 0)
           solution.append("The diagonal of L consists of all entries = 1.0:\n");
        else
           solution.append("The diagonal of U consists of all entries = 1.0:\n");
        solution.append("\nThe diagonal of L below/on diagonal and entries of U above");
        solution.append("/on diagonal\n");
        solution.append("- output by rows in overwrite format:\n");

 
       for (I=1; I<=N; I++) {
          for (J=1; J<=N; J++) solution.append(""+formatter.format(A[I-1][J-1])+"    ");
          solution.append("\n");
         }

    }

  public void arrayInput(double arr[][], String str){

     try{
         
      String[] charArray = StringtoArray(str,","); 
      if(N>(charArray.length/N)) {
         solution.append("Dimension is greater than matrix entered\n");
         inputCancel = true; 
         }
       else{
      for(int i = 0; i< N; i++){
  
        for(int j=0;j<N; ++j)
             arr[i][j] = Double.parseDouble(charArray[N*i +j]);
       }
      }
    }
   catch(NumberFormatException ex){ inputCancel= true; }       
  }



  public boolean inputCheck()
   {
        String errorInfo;
          if (N <= 0 ){
            solution.append("Order must be a positive integer. \n");
          OK = false;}
          if ((ISW == 0) || (ISW == 1) ){ OK = true;}
             else{
            solution.append("Please enter 0 for L or 1 for U depending which diagonal consists of ones. \n");
          OK = false;}
        if (inputCancel){
            solution.append("Values must be entered for matrix. \n");
            inputCancel = false;
          OK = false;}
          return OK;

   }     



  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    iswField = new JTextField(2);
    exprField = new JTextField(40);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(3,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Dimmension n =:", JLabel.RIGHT));
    inputPanel.add(nDegree);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("Which diagonal", JLabel.RIGHT));
    inputPanel.add(new JLabel("consits of ones?,", JLabel.RIGHT));
    inputPanel.add(new JLabel("0 for L, 1 for U =:", JLabel.RIGHT));
    inputPanel.add(iswField);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel inputPanel2 = new JPanel(new GridLayout(2,2));

    inputPanel2.add(new JLabel("Matrix in row form. Separate elements with commas \",\" A =:", JLabel.RIGHT));
    inputPanel2.add(exprField); exprField.setText("4,-1,1,-1,4.25,2.75,1,2.75,3.5");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }


  }
    
   
