import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class Crout
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField nDegree, Afield, Bfield, Cfield, BBfield;
  private JTextArea solution;
  private int N, I, J,NN, II; 
  private boolean OK, inputCancel;
  private NumberFormat formatter;
  private double A[], B[], C[], BB[], Z[], X[], temp[];
  

  public void init() {

    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[10]; X = new double[10]; C = new double[10]; B = new double[10];
                BB = new double[10]; Z = new double[10]; temp = new double[10]; 
                N = Integer.parseInt(nDegree.getText());
                OK = true;
    
               toArray(Afield.getText(), A);
               toArray(Bfield.getText(), temp);
               for(I=0;I<N-1;I++) B[I+1] = temp[I];
               toArray(Cfield.getText(), C);
               toArray(BBfield.getText(),BB);

          

           if(inputCheck())
             {
 
             solution.setText("");       
             NN = N-1;
              /* Steps 1-3 set up and solve LZ = B   */
              /* STEP 1 */
              /* the entries of U overwrite C and
                 the entries of L overwrite A */
           C[0] = C[0] / A[0]; 
           Z[0] = BB[0] / A[0];
           /* STEP 2 */
           for (I=2; I<=NN; I++) {
                A[I-1] = A[I-1] - B[I-1] * C[I-2];
                C[I-1] = C[I-1] / A[I-1];
                Z[I-1] = (BB[I-1]-B[I-1]*Z[I-2])/A[I-1];
              }
            /* STEP 3 */
            A[N-1] = A[N-1] - B[N-1] * C[N-2];
            Z[N-1] = (BB[N-1]-B[N-1]*Z[N-2])/A[N-1];
            /* STEP 4 */
            /* STEPS 4, 5 solve UX = Z */
            X[N-1] = Z[N-1];
            /* STEP 5 */
            for (II=1; II<=NN; II++) {
               I = NN - II + 1;
               X[I-1] = Z[I-1] - C[I-1] * X[I];
            }
            /* STEP 6 */
             outPut(N, X);
         }
      }


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************
  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i= 0; i< charArray.length; i++)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }

   public void outPut(int N, double X[])
       {
        
        solution.append("Crout Method for trdiagonal Linear Systems\n\n");
        solution.append("The solution is:\n");

 
        for (I=1; I<=N; I++)  solution.append(""+formatter.format(X[I-1])+"    ");
          solution.append("\n");
       }



  public boolean inputCheck()
   {
        String errorInfo;
          if (N <= 0 ){
            solution.append("Degree must be a positive integer. \n");
          OK = false;}
          return OK;

   }     



  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    Afield = new JTextField(20);
    Bfield = new JTextField(20);
    Cfield = new JTextField(20);
    BBfield = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(2,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Dimmension n =:", JLabel.RIGHT));
    inputPanel.add(nDegree);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel inputPanel2 = new JPanel(new GridLayout(5,2));

    inputPanel2.add(new JLabel("Enter diadonal A(I,I) stored in A(I) =:", JLabel.RIGHT));
    inputPanel2.add(Afield); Afield.setText("2,2,2,2");

    inputPanel2.add(new JLabel("Enter lower subdiagonal A(I,I-1) stored B(I) =:", JLabel.RIGHT));
    inputPanel2.add(Bfield); Bfield.setText("-1,-1,-1");

    inputPanel2.add(new JLabel("Enter upper subdiagonal A(I,I+1) stored C(I) =:", JLabel.RIGHT));
    inputPanel2.add(Cfield); Cfield.setText("-1,-1,-1");

    inputPanel2.add(new JLabel("Enter las column A(I,N+1) stored BB(I) =:", JLabel.RIGHT));
    inputPanel2.add(BBfield); BBfield.setText("1,0,0,1");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(7);
    formatter.setMinimumFractionDigits(7);
  }

 
  }
    
   
