import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class Conjugat
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField nDegree, matAField, matCIField, matX1Field, tolField, iteratn;
  private JTextArea solution;
  private int N, I, J, K, NN; 
  private boolean OK, inputCancel;
  private NumberFormat formatter;
  private double A[][], CI[][], CT[][];
  private double X1[], R[], V[], W[], U[], Z[];
  private double ALPHA, BETA, T, S, SS, QERR, ERR, TOL;
  

  public void init() {
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[10][11]; CI = new double[10][10]; CT = new double[10][10];
                X1 = new double[10]; R = new double[10]; V = new double[10]; W = new double[10];
                U = new double[10]; Z = new double[10];
                N = Integer.parseInt(nDegree.getText());
                NN = Integer.parseInt(iteratn.getText());
                TOL = Double.parseDouble(tolField.getText());

                OK = true; inputCancel = false;
                arrayInput(A, matAField.getText(),N+1);
                arrayInput(CI, matCIField.getText(),N);
                toArray(matX1Field.getText(), X1);
                solution.setText("");       

           if(inputCheck())
             {
            solution.setText("");       
      /* STEP 1 */
      for (I=1; I<=N; I++)
        { for (J=1; J<=N; J++) CT[I-1][J-1] = CI[J-1][I-1];
        }
      for (I=1; I<=N; I++)
        { R[I-1] = A[I-1][N];
         for (J=1; J<=N; J++) R[I-1] = R[I-1] - A[I-1][J-1]*X1[J-1];
        }
      for (I=1; I<=N; I++)
        { W[I-1] = 0.0;
         for (J=1; J<=N; J++) W[I-1] = W[I-1] + CI[I-1][J-1]*R[J-1];
        }
      for (I=1; I<=N; I++)
        { V[I-1] = 0.0;
         for (J=1; J<=N; J++) V[I-1] = V[I-1] + CT[I-1][J-1]*W[J-1];
        }
      ALPHA = 0.0;
      for (I=1; I<=N; I++) ALPHA = ALPHA + W[I-1] * W[I-1];
      /* STEP 2 */
      K = 1;
      OK = false;
      /* STEP 3 */
      while ((!OK) && (K <= NN)) {
         /* err is used to test accuracy - it measures the  
         2-norm */
         ERR = 0.0; 
         /* STEP 4 */
         for (I=1; I<=N; I++)  ERR = ERR + V[I-1] * V[I-1];
         if (Math.sqrt(ERR) <= TOL) {
            OK = true;
            K = K - 1;
         }
         /* process is complete */
         else
            /* STEP 5 */
          {  for (I=1; I<=N; I++)
              { U[I-1] = 0.0;
              for (J=1; J<=N; J++) U[I-1] = U[I-1] + A[I-1][J-1]*V[J-1];
            }
            S = 0.0;
            for (I=1; I<=N; I++) S = S + V[I-1] * U[I-1];
            T = ALPHA/S;
            for (I=1; I<=N; I++)
              { X1[I-1] = X1[I-1] + T * V[I-1];
                R[I-1] = R[I-1] - T * U[I-1];
            }
            for (I=1; I<=N; I++)
              { W[I-1] = 0.0;
              for (J=1; J<=N; J++) W[I-1] = W[I-1] + CI[I-1][J-1]*R[J-1];
            }
            BETA = 0.0;
            for (I=1; I<=N; I++) BETA = BETA + W[I-1] * W[I-1];
            /* STEP 6 */ 
            if ( Math.sqrt(BETA) <= TOL)
             {
               ERR = 0.0;
               for (I=1; I<=N; I++) ERR = ERR + R[I-1]*R[I-1];
               if (Math.sqrt(ERR) < TOL ) {
                  OK = true;
               }
             }
            if (!OK)
             {
             /* STEP 7 */
              K = K +1;
              S = BETA/ALPHA;
            for (I=1; I<=N; I++)
              { Z[I-1] = 0.0;
              for (J=1; J<=N; J++) Z[I-1] = Z[I-1] + CT[I-1][J-1]*W[J-1];
            }
            for (I=1; I<=N; I++) V[I-1] = Z[I-1] + S * V[I-1];
            ALPHA = BETA;
            }
         }
      }
      if (!OK) solution.append("Maximum Number of Iterations Exceeded.\n");
      /* STEP 8 */
      /* procedure completed unsuccessfully */
      else outPut(N, X1, R, K, TOL);
      
      }
}


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************


  public void arrayInput(double arr[][], String str, int a){

     try{
 
      String[] charArray = StringtoArray(str,",");
   if(N>0){ 
      if(N>(charArray.length/N)) {
//         solution.append("Dimension is greater than matrix entered\n");
         inputCancel = true; 
         }
       else{
      for(int i = 0; i< N; i++){
  
        for(int j=0;j<a; ++j)
             arr[i][j] = Double.parseDouble(charArray[a*i +j]);
       }
      }
     }
    }
   catch(NumberFormatException ex){ inputCancel= true; }       
  }

  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i= 0; i< charArray.length; i++)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }


  public boolean inputCheck()
   {
   
          if (N <= 0 ){
            solution.append("Please the Number of Equations, It must be a positive integer. \n");
          OK = false;}
          if (NN <= 0 ){
            solution.append("Number of Iterations must be a positive integer. \n");
          OK = false;}

          if (TOL <= 0 ){
            solution.append("Tolerance must be a positive number. \n");
          OK = false;}


        if (inputCancel){
            solution.append("Dimension is greater than matrix entered\n");
            solution.append("Values must be entered for matrix. \n");
            inputCancel = false;
          OK = false;}
          return OK;

   }    
   public void outPut(int N, double X1[], double R[], int K,double TOL)
       {
        int I;
        solution.append("Congugate Gradient Method for Linear Systems\n\n");
        solution.append("The solution vector is :\n");
        
        for (I=1; I<=N; I++) solution.append(""+formatter.format(X1[I-1])+"    ");
          solution.append("\nwith residual vector :\n");
        for (I=1; I<=N; I++) solution.append(""+formatter.format(R[I-1])+"    ");
          solution.append("\nusing "+K+" iterations\n");
          solution.append("with Tolerance "+TOL+" in infinity-norm");
       
        }

   public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    tolField = new JTextField(2);
    iteratn = new JTextField(2);
    matAField = new JTextField(40);
    matCIField = new JTextField(40);
    matX1Field = new JTextField(40);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(3,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Equations n =:", JLabel.RIGHT));
    inputPanel.add(nDegree);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Iterations  =:", JLabel.RIGHT));
    inputPanel.add(iteratn);
    inputPanel.add(new JLabel("Tolerance  =:", JLabel.RIGHT));
    inputPanel.add(tolField);


    JPanel inputPanel2 = new JPanel(new GridLayout(4,2));

    inputPanel2.add(new JLabel("A(i,j) in row form. Separate elements with commas \",\" A =:", JLabel.RIGHT));
    inputPanel2.add(matAField); matAField.setText("4,3,0,24,3,4,-1,30,0,-1,4,-24");

    inputPanel2.add(new JLabel("C(i,j), the preconditioner, Separate elements with commas \",\" C =:", JLabel.RIGHT));
    inputPanel2.add(matCIField); matCIField.setText("1,0,0,0,1,0,0,0,1");

    inputPanel2.add(new JLabel("X(i), initial approximation. Separate elements with commas \",\" X =:", JLabel.RIGHT));
    inputPanel2.add(matX1Field); matX1Field.setText("0,0,0");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
