import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class Cheby
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  

  private JButton startButton, space;  // button objects
  private JTextField lnInt, lmInt, matAField;
  private JTextArea solution;
  private int I, I1,  IP, J, JJ, JP, J1, K, KK, NN, N1, N2, LL, IMAX, NCOPY ; 
  private int LN, LM, BN, PP, N, M, NROW[];
  private boolean OK;
  private NumberFormat formatter;
  private double A[][], AA[], P[], Q[], AMAX, XM, SUM;
  

  public void init() {
 
    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                A = new double[11][12]; AA = new double[11]; P = new double[7];
                Q = new double[7]; NROW = new int[11];
                LN = Integer.parseInt(lnInt.getText());
                LM = Integer.parseInt(lmInt.getText());
                BN = LN + LM ;
                OK = true;

                toArray(matAField.getText(), AA);

           if(inputCheck())
             {
            solution.setText("");       
      /* STEP 1 */
      N = BN;
      M = N + 1;
      /* STEP 2  -  performed in input */
      for (I=0; I<=N; I++) NROW[I] = I;
      /* initialize row pointer */
      NN = N - 1;
      /* STEP 3 */
      Q[0] = 1.0;
      /* STEP 4 */
      /* set up a linear system with matrix A instead of B  */
      for (I=0; I<=N; I++) {
         /* STEP 5 */
         for (J=0; J<=I; J++) 
            if (J <= LN) A[I][J] = 0.0;
         /* STEP 6 */
         if (I <= LN) A[I][I] = 1.0;
         /* STEP 7 */
         for (J=I+1; J<=LN; J++) A[I][J] = 0.0;
         /* STEP 8 */
         for (J=LN+1; J<=N; J++) {
            if (I != 0) {
               PP = I-J+LN;
               if (PP < 0) PP = -PP;
               A[I][J] = -(AA[I+J-LN]+AA[PP])/2.0;
            }  
            else A[I][J] = -AA[J-LN]/2.0;
         }  
         A[I][N+1] = AA[I];
      }  
      /* STEP 9 */
      A[0][N+1] = A[0][N+1]/2.0;
      /* STEPS 10-21 solve the linear system using partial pivoting */
      I = LN+1;
      /* STEP 10 */
      while (OK && (I <= NN)) {
         /* STEP 11 */
         IMAX = NROW[I];
         AMAX = Math.abs(A[IMAX][I]);
         IMAX = I;
         JJ = I + 1;
         for (IP=JJ; IP<=N; IP++) {
            JP = NROW[IP];
            if (Math.abs(A[JP][I]) > AMAX) {
               AMAX = Math.abs(A[JP][I]);
               IMAX = IP;
            }  
         }  
         /* STEP 12 */
         if (AMAX <= 0) OK = false;
         else {
            /* STEP 13 */
            /* simulate row interchange */
            if (NROW[I] != NROW[IMAX]) {
               NCOPY = NROW[I];
               NROW[I] = NROW[IMAX];
               NROW[IMAX] = NCOPY;
            }  
            I1 = NROW[I];
            /* STEP 14 */
            /* Perform elimination. */
            for (J=JJ; J<=M; J++) {
               J1 = NROW[J];
               /* STEP 15 */
               XM = A[J1][I] / A[I1][I];
               /* STEP 16 */
               for (K=JJ; K<=M; K++) A[J1][K] = A[J1][K] - XM * A[I1][K];
               /* STEP 17 */
               A[J1][I] = 0.0;
            }  
         }  
         I++;
      }
      if (OK) {
         /* STEP 18 */
         N1 = NROW[N];
         if (Math.abs(A[N1][N]) <= 0) OK = false;
         /* system has no unique solution */
         else {
            /* STEP 19 */
            /* start backward substitution */
            if (LM > 0) {
               Q[LM] = A[N1][M] / A[N1][N];
               A[N1][M] = Q[LM];
            }
            PP = 1;
            /* STEP 20 */
            for (K=LN+1; K<=NN; K++) {
               I = NN - K + LN+1;
               JJ = I + 1;
               N2 = NROW[I];
               SUM = A[N2][N+1];
               for (KK=JJ; KK<=N; KK++) {
                  LL = NROW[KK];
                  SUM = SUM - A[N2][KK] * A[LL][M];
               }  
               A[N2][M] = SUM / A[N2][I];
               Q[LM-PP] = A[N2][M];
               PP++;
            }  
            /* STEP 21 */
            for (K=0; K<=LN; K++) {
               I = LN - K;
               N2 = NROW[I];
               SUM = A[N2][N+1];
               for (KK=LN+1; KK<=N; KK++) {
                  LL = NROW[KK];
                  SUM = SUM - A[N2][KK] * A[LL][M];
               }  
               A[N2][M] = SUM;
               P[LN-K] = A[N2][M];
            }  
            /* STEP 22 */
            /* procedure completed successfully */
            outPut(Q, P, LN, LM);
         }  
      }

      if (!OK) solution.append("System has no unique solution\n");
      }
}


      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
   public String[] StringtoArray( String s, String sep ) {
       // convert a String s to an Array, the elements
       // are delimited by sep
       StringBuffer buf = new StringBuffer(s);
       int arraysize = 1;
       for ( int i = 0; i < buf.length(); i++ ) {
         if ( sep.indexOf(buf.charAt(i) ) != -1 )
         arraysize++;
        }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************

   public void outPut(double Q[], double P[],int LN,int LM)
       {
        int I;
        solution.append("Chebychev Rational Approximation\n\n");
        solution.append("Denominator Coefficients Q(i):\n");
        for (I=0; I<=LM; I++) solution.append(""+formatter.format(Q[I])+"    ");
        solution.append("\n\n");
        solution.append("Numerator Coefficients P(i):\n");
        for (I=0; I<=LN; I++) solution.append(""+formatter.format(P[I])+"    ");
        solution.append("\n\n");

        }


  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i= 0; i< charArray.length; i++)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }


  public boolean inputCheck()
   {
   
       if ((LN < 0 )||(LM < 0)){
         solution.append("m and n must be a positive integer. \n");
          OK = false;}
          if ((LN == 0 )&&(LM == 0 )){
            solution.append("Not both m and n can be 0. \n");
          OK = false;}

         return OK;
   }     



  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    lnInt = new JTextField(2);
    lmInt = new JTextField(2);
    matAField = new JTextField(40);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(2,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("m =:", JLabel.RIGHT));
    inputPanel.add(lmInt);
    inputPanel.add(new JLabel("n =:", JLabel.RIGHT));
    inputPanel.add(lnInt);

    JPanel inputPanel2 = new JPanel(new GridLayout(2,2));

    inputPanel2.add(new JLabel("A(i) in row form. Separate elements with commas \",\" A =:", JLabel.RIGHT));
    inputPanel2.add(matAField); matAField.setText("2.532131756,-1.130318208,0.2714953396,-.04433684985,0.005474240443,-.0005429263119");

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel, "North"); 
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
