
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Broy
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField approxX, approxY, approxZ, intNN, intN, tolerance, expr1, expr2,expr3;
  private JTextField expr4, expr5, expr6, expr7, expr8, expr9, expr10, expr11, expr12;
  private JTextArea solution;
  private double A[][], B[][], U[], X[], V[], S[], Y[], Z[]; 
  private double SN, TOL, VV, ZN, P, SZN;
  private int N, NN, I, J, K, KK, FLAG;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue, yValue, zValue;

  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 A = new double[10][10]; B= new double[10][10]; X = new double[10]; Y = new double[10];
                 U = new double[10]; V = new double[10]; S = new double[10]; Z = new double[10];
                 TOL = Double.parseDouble(tolerance.getText());
                 N = Integer.parseInt(intN.getText());
                 NN = Integer.parseInt(intNN.getText());
                 X[0] = Double.parseDouble(approxX.getText());
                 X[1] = Double.parseDouble(approxY.getText());
                 X[2] = Double.parseDouble(approxZ.getText());
                 OK  = true; 
                 solution.setText("");             
                 FLAG = 2;
                 
            if(inputCheck()){
                 solution.setText("");
                 solution.append("Broyden Algorithm.\n\n");
                 if(N==3) solution.append("Iteration\tX\tY\tZ\tError\n");             
                 else solution.append("Iteration\tX\tY\tError\n");             
      /* STEP 1 */
      /* A will hold the Jacobian for the initial approximation
         the subprogram PD computes the entries of the Jacobian */
      for (I=1; I<=N; I++) {
         for (J=1; J<=N; J++) A[I-1][J-1] = functnPD(I, J);
         /* Compute V = functnF( X(0) )
            The subprogram functnF( I ) computes the Ith
            component of F at X */
         V[I-1] = functnF(I);
      }  
      /* STEP 2 */
      INVERT();
      /* INVERT finds the inverse of the N by N matrix A and
         returns it in A */
      if (OK) {
         /* STEP 3 */
         K = 2;
         /* NOTE: S = S(1) */
         MULT(V, S);SN = SZN;
         /* MULT computes the product S = -A * V
            and the L2-norm SN of S */
         for (I=1; I<=N; I++) X[I-1] = X[I-1] + S[I-1];
         if (FLAG == 2) {
               solution.append( (K-1)+"\t");
               for (I=1; I<=N; I++) solution.append(formatter.format( X[I-1])+"\t" );
               solution.append( SN+"\n");

         }
         /* STEP 4 */
         while ((K < NN) && OK) {
            /* STEP 5 */
            /* The vector W is not used since the
               function F is evaluated component
               by component */
            for (I=1; I<=N; I++) {
               VV = functnF(I);
               Y[I-1] = VV - V[I-1];
               V[I-1] = VV;
            }  
            /* NOTE: V = functnF( X(K) ) AND Y = Y(K) */
            /* STEP 6 */
            MULT(Y, Z); ZN = SZN;
            /* NOTE : Z = -A(K-1)**-1 * Y(K) */
            /* STEP 7 */
            P = 0.0;
            /* P WILL BE S(K)**T * A(K-1)**-1 * Y(K) */
            for (I=1; I<=N; I++) {
               P = P - S[I-1] * Z[I-1];
            }
            /* STEP 8 */
            for (I=1; I<=N; I++) { 
               U[I-1] = 0.0;
               for (J=1;J<=N;J++)
                  U[I-1] = U[I-1]+S[J-1]*A[J-1][I-1];
            }
            /* STEP 9 */
            for (I=1;I<=N;I++) {
               for (J=1;J<=N;J++)
                  A[I-1][J-1] = A[I-1][J-1]+(S[I-1]+Z[I-1])*U[J-1]/P;
            }
            /* STEP 10 */
            MULT(V, S); SN = SZN;
            /* NOTE: A = A(K)**-1 and S = -A(K)**-1 * functnF( X(K) ) */
            /* STEP 11 */
            for (I=1; I<=N; I++) X[I-1] = X[I-1] + S[I-1];
            /* NOTE: X = X(K+1) */
            KK = K + 1;
            if (FLAG == 2) {
               solution.append( K+"\t");
               for (I=1; I<=N; I++) solution.append(formatter.format( X[I-1])+"\t" );
               solution.append( SN+"\n");
            }  
            if (SN <= TOL) {
               /* procedure completed successfully */
               OK = false;
               solution.append( "Iteration number "+ K + " gives solution:\n");
               for (I=1; I<=N; I++) solution.append( formatter.format( X[I-1])+"\t");
               solution.append( "\nto within tolerance "+ TOL);
            }  
            else 
               /* STEP 13 */
               K = KK;
         }  
         if (K >= NN)
            /* STEP 14 */
            solution.append("Procedure does not converge in "+NN+" iterations\n");
              }
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }

/*  MULT computes S = -A*V and SN = 2-norm of S  */ 
public void MULT(double V[], double S[])
{
   int I, J;

   SZN = 0.0;
   for (I=1; I<=N; I++) {
      S[I-1] = 0.0;
      for (J=1; J<=N; J++) S[I-1] = S[I-1] - A[I-1][J-1] * V[J-1];
      SZN = SZN + S[I-1] * S[I-1];
   }
   SZN = Math.sqrt(SZN);
}
/*  INVERT finds the inverse, if possible, of the matrix A and
    returns it in A.  It uses the Gauss-Jordan method with
    partial pivoting and is called only once in this program.  */
  public void INVERT()
   {
   int I,J,I1,I2,K;
   double C;
   
   for (I=1; I<=N; I++) {
      for (J=1; J<=N; J++) B[I-1][J-1] = 0.0;
      B[I-1][I-1] = 1.0;
   }
   I = 1;
   while ((I <= N) && OK) {
      I1 = I + 1;
      I2 = I;
      if (I != N) {
         C = Math.abs(A[I-1][I-1]);
         for (J=I1; J<=N; J++) 
            if (Math.abs(A[J-1][I-1]) > C) {
               I2 = J;
               C = Math.abs(A[J-1][I-1]);
            }  
         if (C <= 0) OK = false;
         else {
            if (I2 != I) 
               for (J=1; J<=N; J++) {
                  C = A[I-1][J-1];
                  A[I-1][J-1] = A[I2-1][J-1];
                  A[I2-1][J-1] = C;
                  C = B[I-1][J-1];
                  B[I-1][J-1] = B[I2-1][J-1];
                  B[I2-1][J-1] = C;
               }  
         }  
      }
      else if (Math.abs(A[N-1][N-1]) <= 0) OK = false;
      if (OK) 
         for (J=1; J<=N; J++) {
            if (J != I) {
               C = A[J-1][I-1] / A[I-1][I-1];
               for (K=1; K<=N; K++) {
                  A[J-1][K-1] = A[J-1][K-1] - C * A[I-1][K-1];
                  B[J-1][K-1] = B[J-1][K-1] - C * B[I-1][K-1];
               }  
            }  
         }  
      I++;
   }  
   if (OK) 
      for (I=1; I<=N; I++) {
         C = A[I-1][I-1];
         for (J=1; J<=N; J++) A[I-1][J-1] = B[I-1][J-1] / C;
      }  
   else solution.append("Jacobian has no inverse\n");
}

     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
		myParser.addVariable("y", yValue);
		myParser.addVariable("z", zValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(int I)
   {
    double f; f = 0;
    xValue = X[0];
    yValue = X[1];  
    zValue = X[2];  
   switch (I) {
      case 1:
          parseExp(expr1.getText());
          f = myParser.getValue(); 
         break;
      case 2:
          parseExp(expr2.getText());
          f = myParser.getValue(); 
         break;
      case 3:
          parseExp(expr3.getText());
          f = myParser.getValue(); 
         break;
   }   
   return f;
}

/*  P is the Jacobian Matrix  J(X)  */
  public double functnPD(int I, int J)
   {
    double p; p = 0;
    xValue = X[0];
    yValue = X[1];  
    zValue = X[2];  
   switch (I) {
      case 1: 
         switch (J) {
            case 1:
                parseExp(expr4.getText());
                p = myParser.getValue(); 
               break;
            case 2:
                parseExp(expr5.getText());
                p = myParser.getValue(); 
               break;
            case 3:
                parseExp(expr6.getText());
                p = myParser.getValue(); 
               break;
         }     
         break;
      case 2:
         switch (J) {
            case 1:
                parseExp(expr7.getText());
                p = myParser.getValue(); 
               break;
            case 2:
                parseExp(expr8.getText());
                p = myParser.getValue(); 
               break;
            case 3:
                parseExp(expr9.getText());
                p = myParser.getValue(); 
               break;
         }     
         break;
      case 3:
         switch (J) {
            case 1:
                parseExp(expr10.getText());
                p = myParser.getValue(); 
               break;
            case 2:
                parseExp(expr11.getText());
                p = myParser.getValue(); 
               break;
            case 3:
                parseExp(expr12.getText());
                p = myParser.getValue(); 
               break;
         }     
         break;
   }
   return p;
}
   

  public boolean inputCheck()
   {
        String errorInfo;
          if (NN <= 0 ){
            solution.append("Iterations must be a positive integer. \n");
            OK = false;}

          if ((N < 2) || (N >3)){
            solution.append("You can only work with 2 or 3 non linear equations. \n");
            OK = false;}

          if (TOL <= 0){
            solution.append("Tolerance must be positive. \n");
            OK = false;}
          

          parseExp(expr1.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr2.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr3.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr4.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr5.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr6.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr7.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr8.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr9.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr10.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr11.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          parseExp(expr12.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    intN = new JTextField(4);
    intNN = new JTextField(4);
    approxX = new JTextField(4);
    approxY = new JTextField(4);
    approxZ = new JTextField(4);
    tolerance = new JTextField(6);
    expr1 = new JTextField(20);
    expr2 = new JTextField(20);
    expr3 = new JTextField(20);
    expr4 = new JTextField(20);
    expr5 = new JTextField(20);
    expr6 = new JTextField(20);
    expr7 = new JTextField(20);
    expr8 = new JTextField(20);
    expr9 = new JTextField(20);
    expr10 = new JTextField(20);
    expr11 = new JTextField(20);
    expr12 = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(8,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("f1(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr1); expr1.setText("3*x-cos(y*z) - 0.5");
    inputPanel.add(new JLabel("f2(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr2); expr2.setText("x^2 - 81*(y+0.1)^2 + sin(z) + 1.06");
    inputPanel.add(new JLabel("f3(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr3); expr3.setText("e^(-x*y) + 20*z + (10*pi-3)/3");

    inputPanel.add(new JLabel("P1x(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr4); expr4.setText("3");
    inputPanel.add(new JLabel("P1y(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr5); expr5.setText("z*sin(y*z)");
    inputPanel.add(new JLabel("P1z(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr6); expr6.setText("y*sin(y*z)");

    inputPanel.add(new JLabel("P2x(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr7); expr7.setText("2*x");
    inputPanel.add(new JLabel("P2y(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr8); expr8.setText("-162*(y+0.1)");
    inputPanel.add(new JLabel("P2z(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr9); expr9.setText("cos(z)");

    inputPanel.add(new JLabel("P3x(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr10); expr10.setText("-y*e^(-x*y)");
    inputPanel.add(new JLabel("P3y(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr11); expr11.setText("-x*e^(-x*y)");
    inputPanel.add(new JLabel("P3z(x,y,z) =:", JLabel.RIGHT));
    inputPanel.add(expr12); expr12.setText("20");


    inputPanel.add(new JLabel("Approx X =:", JLabel.RIGHT));
    inputPanel.add(approxX);
    inputPanel.add(new JLabel("Approx Y =:", JLabel.RIGHT));
    inputPanel.add(approxY);
    inputPanel.add(new JLabel("Approx Z =:", JLabel.RIGHT));
    inputPanel.add(approxZ);

    inputPanel.add(new JLabel("No of Equatns:", JLabel.RIGHT));
    inputPanel.add(intN);intN.setText("3");
    inputPanel.add(new JLabel("Iterations =:", JLabel.RIGHT));
    inputPanel.add(intNN);
    inputPanel.add(new JLabel(" TOL =:", JLabel.RIGHT));
    inputPanel.add(tolerance);

  
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
