
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Bisect
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField midPoint, pointA, pointB, tTolerance, nIteration, exprField;
  private JTextArea solution;
  private double a, b, c, p,fa, fb, fp, TOL;
  private int I, iterations;
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;


  public void init() {
    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 a = Double.parseDouble(pointA.getText());
                 b = Double.parseDouble(pointB.getText());
               TOL = Double.parseDouble(tTolerance.getText());
         iterations = Integer.parseInt(nIteration.getText());
                OK  = true; 
            solution.setText("");             

            if(inputCheck()){ I= 1;
            solution.append("  "+"I\tA\tB\tp\tF(p) \n");  
            solution.append("===============================================================\n");       
       while(I<=iterations && OK){
               c = (b - a)/2;
               p = a + c ;

               fp =functnF(p);
               solution.append(" "+ I  +"\t"+ formatter.format(a) +"\t"+formatter.format(b)+"\t"+formatter.format(p)+"\t"+formatter.format(fp)+"\n");       
            if (absVal(fp)< 0 || c<TOL)
               {
                solution.append("No of Iterations "+I+" \n");
                solution.append("Approximation solution "+formatter.format(p)+" \n");
                solution.append("Tolerance "+ TOL);

                OK = false;}
            else{
                  I++; 
                  if( fa*fp > 0){a = p; fa = fp;}
                    else{ b = p; fb = fp;}
                    }
                }
        if (OK){
          solution.append("No of Iterations "+nIteration.getText()+" \n");
          solution.append("gave approximation "+formatter.format(p)+" \n");
          solution.append("not within tolerance "+ TOL);}
          }
        }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
   public void parseExpression() {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
		myParser.parseExpression(exprField.getText());
	}


  public double functnF(double point)
   {
    double f;
    xValue = point;  
    parseExpression();
    f = myParser.getValue();  // example   f = (x + 4.0)*x^2 - 10.0;
    return f;
   }
  
  public boolean inputCheck()
   {
        String errorInfo;
        double ab;
        if( a > b){ab = a; a = b; b = ab;}
          if ( a == b){
            solution.append("A cannot equal B \n");  
            OK = false;}else{fa= functnF(a); fb=functnF(b);
                              if(fa*fb>0){solution.append("f(a) and f(b) have same sign");
                                 OK = false;} }
          if (TOL <= 0.0){
            solution.append("Tolerance must be positive \n");
            OK = false;}
          if (iterations <= 0 ){
            solution.append("Number of Iterations must be positive Integer\n");
            OK = false;}
            parseExpression();
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          return OK;
   }     

 public double absVal(double val)
  { 
    if( val >= 0) return val;
    else return -val;
  }  
 
   public void setVisualComponent()
    {
    startButton = new JButton("Start");
    pointA = new JTextField(4);
    pointB = new JTextField(4);
    tTolerance = new JTextField(6);
    nIteration = new JTextField(2);
    exprField = new JTextField("(x + 4.0)*x^2 - 10.0");
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    
    JPanel inputPanel1 = new JPanel(new GridLayout(3,3));

    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("Function f(x) =:", JLabel.RIGHT));
    inputPanel1.add(exprField); 
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));

    JPanel inputPanel2 = new JPanel(new GridLayout(3,6));

    inputPanel2.add(new JLabel("Point A:", JLabel.RIGHT));
    inputPanel2.add(pointA);
    inputPanel2.add(new JLabel("Point B:", JLabel.RIGHT));
    inputPanel2.add(pointB);
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel2.add(new JLabel("TOL:", JLabel.RIGHT));
    inputPanel2.add(tTolerance);
    inputPanel2.add(new JLabel("No Iterations:", JLabel.RIGHT));
    inputPanel2.add(nIteration);
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));


    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputAreaPanel = new JPanel(new BorderLayout());
    inputAreaPanel.add(inputPanel1, "North");
    inputAreaPanel.add(inputPanel2, "South");

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputAreaPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);

      }


  }
    
   
