import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;


public class Bezi
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JButton startButton, space;  // button objects
  private JTextField pointX0, nDegree, xValues, yValues, x1Values, y1Values, x2Values, y2Values; 
  private JTextArea solution;
  private int I, n; 
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;

  private double A0[], A1[], A2[], A3[], B0[], B1[], B2[], B3[], X[], Y[], temp[];
  private double XPL[], YPL[], XMI[], YMI[];

  public void init() {

    setVisualComponent();    
   
    }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {

                    n = Integer.parseInt(nDegree.getText());
                
                OK  = true;
                    
                    A0 = new double[25]; A1 = new double[25]; A2 = new double[25]; A3 = new double[25];
                    B0 = new double[25]; B1 = new double[25]; B2 = new double[25]; B3 = new double[25];
                    XPL = new double[25]; YPL = new double[25]; XMI = new double[25]; YMI = new double[25];
                    X = new double[26];
                    Y = new double[26];
        
            solution.setText("");            

           if(inputCheck())
             {

                    toArray(xValues.getText(), X);
                    toArray(yValues.getText(), Y);
                    toArray(x1Values.getText(), XMI);
                    toArray(y1Values.getText(), YMI);
                    toArray(x2Values.getText(), XPL);
                    toArray(y2Values.getText(), YPL);

               for(I=0; I<=n-1; I++)
                  {
                   A0[I] = X[I];
                   B0[I] = Y[I]; 
                   A1[I] = 3*(XPL[I] - X[I]);
                   B1[I] = 3*(YPL[I] - Y[I]);
                   A2[I] = 3*(X[I]+XMI[I] -2* XPL[I]);
                   B2[I] = 3*(Y[I]+YMI[I] -2* YPL[I]);
                   A3[I] = X[I+1] - X[I] + 3*XPL[I] -3* XMI[I];
                   B3[I] = Y[I+1] - Y[I] + 3*YPL[I] -3* YMI[I];
                   }

                outPut();
               }

            }

      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
//****************************************************************
public String[] StringtoArray( String s, String sep ) {
    // convert a String s to an Array, the elements
    // are delimited by sep
    StringBuffer buf = new StringBuffer(s);
    int arraysize = 1;
    for ( int i = 0; i < buf.length(); i++ ) {
      if ( sep.indexOf(buf.charAt(i) ) != -1 )
        arraysize++;
    }
    String [] elements  = new String [arraysize];
    int y,z = 0;
    if ( buf.toString().indexOf(sep) != -1 ) {
      while (  buf.length() > 0 ) {
        if ( buf.toString().indexOf(sep) != -1 ) {
          y =  buf.toString().indexOf(sep);
          if ( y != buf.toString().lastIndexOf(sep) ) {
            elements[z] = buf.toString().substring(0, y ); z++;
            buf.delete(0, y + 1);
          }
          else if ( buf.toString().lastIndexOf(sep) == y ) {
            elements[z] = buf.toString().substring(0, buf.toString().indexOf(sep) );z++;
            buf.delete(0, buf.toString().indexOf(sep) + 1);
            elements[z] = buf.toString();z++;
            buf.delete(0, buf.length() );
          }
        }
      }
    }
    else {elements[0] = buf.toString(); }
    buf = null;
    return elements;
  }

//****************************************************************
 

  public void toArray(String s, double arr[])
   {
    
    String[] charArray = StringtoArray(s,","); //.split(",\\s*"); 
    for(int i=0;i<charArray.length; ++i)
       {
         arr[i] = Double.parseDouble(charArray[i]);
       }
      
     }


  public boolean inputCheck()
   {
        String errorInfo;
          if (n <= 0 ){
            solution.append("Degree must be a positive integer. \n");
            OK = false;}
          if(xValues.getText()== null || xValues.getText().equals("")){ 
            solution.append("Must enter values for x(i) \n");
            OK = false;}
          if(yValues.getText()== null || yValues.getText().equals("")){ 
            solution.append("Must enter values for y(i) \n");
            OK = false;}
          if(x1Values.getText()== null || x1Values.getText().equals("")){ 
            solution.append("Must enter values for x(i-1) \n");
            OK = false;}
          if(y1Values.getText()== null || y1Values.getText().equals("")){ 
            solution.append("Must enter values for y(i-1) \n");
            OK = false;}
          if(x2Values.getText()== null || x2Values.getText().equals("")){ 
            solution.append("Must enter values for x(i+1) \n");
            OK = false;}
          if(y2Values.getText()== null || y2Values.getText().equals("")){ 
            solution.append("Must enter values for y(i+1) \n");
            OK = false;}


            return OK;

   }     

   public void outPut()
      {

         solution.append(" "+"i\t"+"A0[i]\t"+"A1[i]\t"+"A2[i]\t"+"A3[i]\n"); 
         for(I=0; I<=n-1; I++)
            { 
             solution.append(""+I+"\t"+formatter.format(A0[I])+"\t"+formatter.format(A1[I])+"\t"+formatter.format(A2[I])+"\t"+formatter.format(A3[I])+"\n"); 
            }
         solution.append("\n "+"i\t"+"B0[i]\t"+"B1[i]\t"+"B2[i]\t"+"B3[i]\n"); 
         for(I=0; I<=n-1; I++)
            { 
             solution.append(""+I+"\t"+formatter.format(B0[I])+"\t"+formatter.format(B1[I])+"\t"+formatter.format(B2[I])+"\t"+formatter.format(B3[I])+"\n"); 
            }
      } 

  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    nDegree = new JTextField(2);
    xValues = new JTextField("3, 2, 6, 5, 6.5");
    yValues = new JTextField("6, 2, 6, 2, 3");
    x1Values = new JTextField("2.5, 5, 4.5, 6.4");
    y1Values = new JTextField("2.5, 5.8, 2.5, 2.8");
    x2Values = new JTextField("3.3, 2.8, 5.8, 5.5");
    y2Values = new JTextField("6.5, 3, 5, 2.2");

    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel1 = new JPanel(new GridLayout(2,6));

    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel1.add(new JLabel("n =:", JLabel.RIGHT));
    inputPanel1.add(nDegree);

    JPanel inputPanel2 = new JPanel(new GridLayout(10,2));

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel2.add(new JLabel("Xo, X1, X2,..,Xn:", JLabel.RIGHT));
    inputPanel2.add(xValues);
    inputPanel2.add(new JLabel("Yo, Y1, Y2,..,Yn:", JLabel.RIGHT));
    inputPanel2.add(yValues);

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel2.add(new JLabel("Xo-1, X1-1, X2-1,..,Xn-1:", JLabel.RIGHT));
    inputPanel2.add(x1Values);
    inputPanel2.add(new JLabel("Yo-1, Y1-1, Y2-1,..,Yn-1:", JLabel.RIGHT));
    inputPanel2.add(y1Values);

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel2.add(new JLabel("Xo+1, X1+1, X2+1,..,Xn+1:", JLabel.RIGHT));
    inputPanel2.add(x2Values);
    inputPanel2.add(new JLabel("Yo+1, Y1+1, Y2+1,..,Yn+1:", JLabel.RIGHT));
    inputPanel2.add(y2Values);

    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel2.add(new JLabel("           ", JLabel.RIGHT));
    

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel inputArea = new JPanel(new BorderLayout());
    inputArea.add(inputPanel1, "North");
    inputArea.add(inputPanel2, "South");
     
    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputArea, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(7);
    formatter.setMinimumFractionDigits(7);
  }


  }
    
   
