
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Adapt
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB,tolerance, nLevels, exprField;
  private JTextArea solution;
  private double TOL[], A[], H[], FA[], FB[], FC[], S[], V[];
  private double AA, BB, EPS, APP,FD, FE, S1, S2;
  private int I, CNT, N, LEV;
  private int L[];
  private boolean OK;
  private NumberFormat formatter;
  private double xValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 TOL = new double[20]; A = new double[20]; H = new double[20]; FA = new double[20];
                 FC = new double[20]; FB = new double[20]; S = new double[20]; V = new double[20];
                  L = new int[20];
                 AA = Double.parseDouble(endPointA.getText());
                 BB = Double.parseDouble(endPointB.getText());
                 N = Integer.parseInt(nLevels.getText());
                 EPS = Double.parseDouble(tolerance.getText());
                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
                 OK = true;
                CNT = 0;
                APP = 0;
                I = 1;
                TOL[I] = 10 * EPS;
                A[I] = AA;
                H[I] = 0.5*(BB - AA);
                FA[I]= functnF(AA);
                FC[I]= functnF(AA + H[I]);
                FB[I]= functnF(BB);
                S[I] = H[I]*(FA[I] + 4.0*FC[I] + FB[I])/3.0;
                L[I] = 1;
            while((I > 0) && OK){
                  FD  = functnF(A[I] + 0.5*H[I]);
                  FE  = functnF(A[I] + 1.5*H[I]);
                  S1  = H[I]*(FA[I] + 4.0*FD + FC[I])/6.0;
                  S2  = H[I]*(FC[I] + 4.0*FE + FB[I])/6.0;
                  V[0] = A[I];
                  V[1] = FA[I];
                  V[2] = FC[I];
                  V[3] = FB[I];
                  V[4] = H[I];
                  V[5] = TOL[I];
                  V[6] = S[I];
                  LEV = L[I];
                  I--;
              if(absVal(S1 + S2 - V[6]) < V[5])
                  APP = APP + ( S1 + S2);
              	else{
                   if( LEV >= N) {OK = false;} // procedure fails
                     else{
                          I++;
                          A[I] = V[0] +V[4];
                          FA[I]= V[2];
                          FC[I]= FE;
                          FB[I]= V[3];
                          H[I]= 0.5*V[4];
                          TOL[I]= 0.5*V[5];
                          S[I]= S2;
                          L[I]= LEV + 1;
                          I++;
                          A[I]= V[0];
                          FA[I]= V[1];
                          FC[I]= FD;
                          FB[I]= V[2];
                          H[I]= H[I-1];
                          TOL[I]= TOL[I-1];
                          S[I]= S1;
                          L[I]= L[I-1];
                          }
                      }
                }
                   if(!OK){
                     solution.append("Level exceeded. Method failed to give accurate approximation \n");     
                     solution.append("Please either increase the level N or increase the tolerance"); }    
                   else
                   output();
             
              }
          }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


   public void parseExpression() {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("x", xValue);
                myParser.setImplicitMul(true);
		myParser.parseExpression(exprField.getText());
	}


  public double functnF(double point)
   {
    CNT = CNT + 1;
    double f;
    xValue = point;  
    parseExpression();
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
 public void output()
   {
      solution.append("\n\nThe integral of F from "+AA+" to "+BB+" is "+formatter.format(APP));
      solution.append("\nto within a tolerance of "+EPS);
      solution.append(" The number of functions evaluated is:"+ CNT);
   }      
 public double absVal(double val)
  { 
    if( val >= 0) return val;
    else return -val;
  }  

  public boolean inputCheck()
   {
        String errorInfo;
          if (AA >= BB ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (N <=0 ){
            solution.append("N must be positive \n");
            OK = false;}
          if (EPS <=0 ){
            solution.append("Tolerance must be positive \n");
            OK = false;}
            parseExpression();
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}
          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    nLevels = new JTextField(2);
    tolerance = new JTextField(10);
    exprField = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(4,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("Function f(x) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("(100/x^2)*sin(10/x)");
    inputPanel.add(new JLabel(" N =:", JLabel.RIGHT));
    inputPanel.add(nLevels);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("endPoint A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel("endPoint B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("Tolerance =:", JLabel.RIGHT));
    inputPanel.add(tolerance);

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }


  }
    
   
