
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class AdamVar
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, alphaCondn, stepHmax, stepHmin, tolerance, exprField;
  private JTextArea solution;
  private double A, B, Tol, Alpha, Hmax, Hmin, H, TT, WP, WC, Sig, Q, K1, K2, K3, K4;
  private double T[], W[];
  private int I, J, K, KK, N, NFlag;
  private boolean OK, Done;
  private NumberFormat formatter;
  private double yValue, tValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 W = new double[100]; T = new double[100];
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 Hmax = Double.parseDouble(stepHmax.getText());
                 Hmin = Double.parseDouble(stepHmin.getText());
                 Alpha = Double.parseDouble(alphaCondn.getText());
                 Tol = Double.parseDouble(tolerance.getText());


                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
                solution.append(" "+" T\tW\tH\tSig\n");
     /* STEP 2 */
      T[0] = A;
      W[0] = Alpha;
      H = Hmax;
      /*  OK is used in place of FLAG to exit the loop in Step 4.  */
      OK = true;
      /*  Done is used in place of LAST to indicate when last value
          is calculated.  */
      Done = false;
      /* STEP 3 */
      for (KK=1; KK<=3; KK++){ 
         //         RK4(H,T[KK-1],W[KK-1],&T[KK],&W[KK]);
      T[KK] = T[KK-1] + H;
      K1 = H * functnF(T[KK-1], W[KK-1]);
      K2 = H * functnF(T[KK-1] + 0.5 * H, W[KK-1] + 0.5 * K1);
      K3 = H * functnF(T[KK-1] + 0.5 * H, W[KK-1] + 0.5 * K2);
      K4 = H * functnF(T[KK], W[KK-1] + K3);
      W[KK] = W[KK-1] + (K1 + 2.0 * (K2 + K3) + K4) / 6.0;
        }
      /* NFlag indicates computation from RK4 */
      NFlag = 1;
      I = 5;
      /* use TT in place of t */
      TT = T[3] + H;
      /* STEP 4 */
      while (!Done) {
         /* STEP 5 */
         /* predict W(I) */
         WP = W[I-2]+H*(55.0*functnF(T[I-2],W[I-2])-59.0*
                     functnF(T[I-3],W[I-3])+37.0*functnF(T[I-4],W[I-4])-
                     9.0*functnF(T[I-5],W[I-5]))/24.0;
         /* correct W(I) */
         WC = W[I-2]+H*(9.0*functnF(TT,WP)+19.0*
              functnF(T[I-2],W[I-2])-5.0*functnF(T[I-3],W[I-3])+
              functnF(T[I-4],W[I-4]))/24.0;
         Sig = 19.0*Math.abs(WC-WP)/(270.0*H);
         /* STEP 6 */
         if (Sig <= Tol) {
            /* STEP 7 */
            /* result accepted */
            W[I-1] = WC;
            T[I-1] = TT;
            /* STEP 8 */
            if (NFlag == 1) {
               K = I - 3;
               KK = I - 1;
               /*  Previous results are also accepted.  */
               for (J=K; J<=KK; J++) 
solution.append(" "+formatter.format(T[J-1])+"\t"+formatter.format(W[J-1])+"\t"+formatter.format(H)                   +"\t"+formatter.format(Sig)+"\n"); 
solution.append(" "+formatter.format(T[I-1])+"\t"+formatter.format(W[I-1])+"\t"+formatter.format(H)                                      +"\t"+formatter.format(Sig)+"\n"); 
            }
            else 
               /*  Previous results were already accepted.  */
solution.append(" "+formatter.format(T[I-1])+"\t"+formatter.format(W[I-1])+"\t"+formatter.format(H)                                      +"\t"+formatter.format(Sig)+"\n"); 
           /* STEP 9 */
            if (!OK) Done = true;
            else  {
               /* STEP 10 */
               I++;
               NFlag = 0;
               /* STEP 11 */
               if ((Sig <= 0.1*Tol) || (T[I-2]+H > B)) {
                  /*  Increase H if more accuracy than required
                      has been obtained, or decrease H to include
                      b as a mesh point.  */
                  /* STEP 12 */
                  /* to avoid underflow */
                  if (Sig <= 1.0e-20) Q = 4.0;
                  else Q = Math.exp(0.25*Math.log(0.5*Tol/Sig)); 
                  /* STEP 13 */
                  if (Q > 4.0)  H = 4.0*H;
                  else H = Q * H;
                  /* STEP 14 */
                  if (H > Hmax) H = Hmax;
                  /* STEP 15 */
                  if (T[I-2]+4.0*H > B) {
                     H = 0.25*(B-T[I-2]);
                     if (H < Tol) Done = true;
                     OK = false;
                  }
                  /* STEP 16 */
                  for (KK=I-1; KK<=I+2; KK++){ 
         //         RK4(H,T[KK-1],W[KK-1],&T[KK],&W[KK]);
      T[KK] = T[KK-1] + H;
      K1 = H * functnF(T[KK-1], W[KK-1]);
      K2 = H * functnF(T[KK-1] + 0.5 * H, W[KK-1] + 0.5 * K1);
      K3 = H * functnF(T[KK-1] + 0.5 * H, W[KK-1] + 0.5 * K2);
      K4 = H * functnF(T[KK], W[KK-1] + K3);
      W[KK] = W[KK-1] + (K1 + 2.0 * (K2 + K3) + K4) / 6.0;
        }
                  NFlag = 1;
                  I = I + 3;
               }  
            }
         }
         else {
            /*  False branch for Step 6 - result rejected.  */
            /* STEP 17 */
            Q = Math.exp(0.25 * Math.log(0.5 * Tol / Sig));
            /* STEP 18 */
            if (Q < 0.1) H = 0.1 * H;
            else H = Q * H;
            /* STEP 19 */
            if (H < Hmin) {
               solution.append("Hmin exceeded\n");
               Done = true;
            }
            else {
               if (T[I-2]+4.0*H > B) H = 0.25*(B-T[I-2]);
               if (NFlag == 1) I = I - 3;
               for (KK=I-1; KK<=I+2; KK++){ 
         //         RK4(H,T[KK-1],W[KK-1],&T[KK],&W[KK]);
      T[KK] = T[KK-1] + H;
      K1 = H * functnF(T[KK-1], W[KK-1]);
      K2 = H * functnF(T[KK-1] + 0.5 * H, W[KK-1] + 0.5 * K1);
      K3 = H * functnF(T[KK-1] + 0.5 * H, W[KK-1] + 0.5 * K2);
      K4 = H * functnF(T[KK], W[KK-1] + K3);
      W[KK] = W[KK-1] + (K1 + 2.0 * (K2 + K3) + K4) / 6.0;
        }
               I = I + 3;
               NFlag = 1;
            }  
         }
         /* STEP 20 */  
         TT = T[I-2] + H;
          }
                   
          }
        }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }
              
 

     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("t", tValue);
		myParser.addVariable("y", yValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2)
   {
    double f;
    tValue = point1;
    yValue = point2;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  

    public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (Tol <=0){
            solution.append("Tolerance must be positive \n");
            OK = false;}

          if (Hmin > Hmax){
            solution.append("Minimum mesh must be less than the maximum mesh spacing\n");
            OK = false;}

          if ((Hmin <=0) || (Hmax <= 0)){
            solution.append("Both Minimum and Maximum mesh spacing must be a positive real \n");
            OK = false;}


          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     
 

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    alphaCondn = new JTextField(4);
    stepHmax = new JTextField(2);
    stepHmin = new JTextField(2);
    tolerance = new JTextField(4);
    exprField = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function f(t,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("y - t^2 + 1");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("Condition Alpha =:", JLabel.RIGHT));
    inputPanel.add(alphaCondn);


    inputPanel.add(new JLabel("Hmin =:", JLabel.RIGHT));
    inputPanel.add(stepHmin);
    inputPanel.add(new JLabel("Hmax =:", JLabel.RIGHT));
    inputPanel.add(stepHmax);
    inputPanel.add(new JLabel("Tolerance =:", JLabel.RIGHT));
    inputPanel.add(tolerance);

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }

  }
    
   
