
import javax.swing.*;  // load visual swing classes
import java.awt.*;     // load layout classes
import java.awt.event.*;  // load event handling classes
import java.text.*;

import org.nfunk.jep.*;
import org.nfunk.jep.type.*;

public class Adam
       extends JApplet  // inherits properties of JFrame class
       implements ActionListener{  // implements event handling
  
  private JEP myParser;

  private JButton startButton, space;  // button objects
  private JTextField endPointA, endPointB, integerN, alphaCondn, exprField;
  private JTextArea solution;
  private double A, B, Alpha, H, K1, K2, K3, K4, T0, W0, T[], W[];
  private int I, J, N;
  private boolean OK;
  private NumberFormat formatter;
  private double yValue, tValue;

  public void init() {

    myParser = new JEP();
    myParser.initFunTab(); // clear the contents of the function table
    myParser.addStandardFunctions();
    myParser.setTraverse(true);

   setVisualComponent();    
   
 }

  public void actionPerformed(ActionEvent e) {


    if (e.getSource() == startButton) {

      try {
                 W = new double[4]; T = new double[4]; 
                 A = Double.parseDouble(endPointA.getText());
                 B = Double.parseDouble(endPointB.getText());
                 N = Integer.parseInt(integerN.getText());
               Alpha = Double.parseDouble(alphaCondn.getText());
                OK  = true; 
            solution.setText("");             

            if(inputCheck()){
              solution.append(" T\tW\n");
                /* STEP 1 */
      H = (B - A) / N;
      T[0] = A;
      W[0] = Alpha;
               solution.append(" "+formatter.format(T[0])+"\t"+formatter.format(W[0])+"\n");
      /* STEP 2 */
      for (I=1; I<=3; I++) {
         /* STEP 3 AND 4 */
         /* compute starting values using Runge-Kutta method */
         /* given in a subroutine */

//         RK4(H, T[I-1], W[I-1]);
      T[I] = T[I-1] + H;
      K1 = H * functnF(T[I-1], W[I-1]);
      K2 = H * functnF(T[I-1] + 0.5 * H, W[I-1] + 0.5 * K1);
      K3 = H * functnF(T[I-1] + 0.5 * H, W[I-1] + 0.5 * K2);
      K4 = H * functnF(T[I], W[I-1] + K3);
      W[I] = W[I-1] + (K1 + 2.0 * (K2 + K3) + K4) / 6.0;
               solution.append(" "+formatter.format(T[I])+"\t"+formatter.format(W[I])+"\n");
         /* STEP 5 */
      }
      /* STEP 6 */
      for (I=4; I<=N; I++) {
         /* STEP 7 */
         /* T0, W0 will be used in place of t, w resp. */
         T0 = A + I * H;
         /* predict W(I) */
         W0 = W[3]+H*(55.0*functnF(T[3],W[3])-59.0*functnF(T[2],W[2])
              +37.0*functnF(T[1],W[1])-9.0*functnF(T[0],W[0]))/24.0;
         /* correct W(I) */
         W0 = W[3]+H*(9.0*functnF(T0,W0)+19.0*functnF(T[3],W[3])
              -5.0*functnF(T[2],W[2])+functnF(T[1],W[1]))/24.0;
         /* STEP 8 */
               solution.append(" "+formatter.format(T0)+"\t"+formatter.format(W0)+"\n");

         /* STEP 9 */
         /* prepare for next iteration */
         for (J=1; J<=3; J++) {
            T[J-1] = T[J];
            W[J-1] = W[J];
         }
         /* STEP 10 */
         T[3] = T0;
         W[3] = W0;
             }
                   
          }
        }
      catch (NumberFormatException ex)
        {
        solution.append("Error");
        }
      }
    }


     public void parseExp(String exp) {
		myParser.initSymTab(); // clear the contents of the symbol table
		myParser.addStandardConstants();
		myParser.addVariable("t", tValue);
		myParser.addVariable("y", yValue);
                myParser.setImplicitMul(true);
                myParser.parseExpression(exp);
	}


  public double functnF(double point1, double point2)
   {
    double f;
    tValue = point1;
    yValue = point2;  
    parseExp(exprField.getText());
    f = myParser.getValue();  // example   g = sqrt(10.0 / (X + 4.0));
    return f;
   }
  
 
  public boolean inputCheck()
   {
        String errorInfo;
          if (A >= B ){
            solution.append("Lower limit must be less than upper limit \n");
            OK = false;}

          if (N < 4){
            solution.append("N must be greater than or equal to 4 \n");
            OK = false;}
          parseExp(exprField.getText());
          if ((errorInfo = myParser.getErrorInfo()) != null){
            solution.append(errorInfo);
            OK =false;}

          return OK;
   }     

 
  public void setVisualComponent()
    {
    startButton = new JButton("Start");
    endPointA = new JTextField(4);
    endPointB = new JTextField(4);
    alphaCondn = new JTextField(4);
    integerN = new JTextField(2);
    exprField = new JTextField(20);
    solution = new JTextArea(17,40);
    JScrollPane scrollPane = new JScrollPane(solution);   
    startButton.addActionListener(this);

    JPanel inputPanel = new JPanel(new GridLayout(5,6));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("Function f(t,y) =:", JLabel.RIGHT));
    inputPanel.add(exprField); exprField.setText("y - t^2 + 1");
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));


    inputPanel.add(new JLabel(" A =:", JLabel.RIGHT));
    inputPanel.add(endPointA);
    inputPanel.add(new JLabel(" B =:", JLabel.RIGHT));
    inputPanel.add(endPointB);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel(" N =:", JLabel.RIGHT));
    inputPanel.add(integerN);
    inputPanel.add(new JLabel("Condition Alpha =:", JLabel.RIGHT));
    inputPanel.add(alphaCondn);
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));
    inputPanel.add(new JLabel("           ", JLabel.RIGHT));

    JPanel buttonPanel = new JPanel(new GridLayout(1,6));
    buttonPanel.add(startButton);
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    
    buttonPanel.add(new JLabel("           ", JLabel.RIGHT));    

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(inputPanel, "North");
    mainPanel.add(scrollPane, "Center");
    mainPanel.add(buttonPanel, "South");

    getContentPane().add(mainPanel);
    
    formatter = NumberFormat.getNumberInstance();
    formatter.setMaximumFractionDigits(9);
    formatter.setMinimumFractionDigits(9);
  }


  }
    
   
