/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.nfunk.jep.JEP;

public class Fixedpt
extends JApplet
implements ActionListener {
    private JEP myParser;
    private JButton startButton;
    private JButton space;
    private JTextField initPoint;
    private JTextField tTolerance;
    private JTextField nIteration;
    private JTextField exprField;
    private JTextArea solution;
    private double p0;
    private double p;
    private double f0;
    private double fp0;
    private double TOL;
    private int I;
    private int iterations;
    private boolean OK;
    private NumberFormat formatter;
    private double xValue;

    public void init() {
        this.myParser = new JEP();
        this.myParser.initFunTab();
        this.myParser.addStandardFunctions();
        this.myParser.setTraverse(true);
        this.setVisualComponent();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.startButton) {
            try {
                this.p0 = Double.parseDouble(this.initPoint.getText());
                this.TOL = Double.parseDouble(this.tTolerance.getText());
                this.iterations = Integer.parseInt(this.nIteration.getText());
                this.OK = true;
                this.solution.setText("");
                if (this.inputCheck()) {
                    this.I = 1;
                    this.solution.append("   I\tG(p)\n ");
                    this.solution.append("=======================\n");
                    while (this.I <= this.iterations && this.OK) {
                        this.p = this.functnG(this.p0);
                        this.solution.append(" " + this.I + "\t" + this.formatter.format(this.p) + "\n");
                        if (this.absVal(this.p - this.p0) < this.TOL) {
                            this.solution.append("No of Iterations " + this.I + " \n");
                            this.solution.append("Approximation solution " + this.formatter.format(this.p) + " \n");
                            this.solution.append("Tolerance " + this.TOL);
                            this.OK = false;
                            continue;
                        }
                        ++this.I;
                        this.p0 = this.p;
                    }
                    if (this.OK) {
                        this.solution.append("No of Iterations " + this.nIteration.getText() + " \n");
                        this.solution.append("gave approximation " + this.formatter.format(this.p) + " \n");
                        this.solution.append("not within tolerance " + this.TOL);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.solution.append("Error");
            }
        }
    }

    public void parseExpression() {
        this.myParser.initSymTab();
        this.myParser.addStandardConstants();
        this.myParser.addVariable("x", this.xValue);
        this.myParser.setImplicitMul(true);
        this.myParser.parseExpression(this.exprField.getText());
    }

    public double functnG(double d) {
        this.xValue = d;
        this.parseExpression();
        double d2 = this.myParser.getValue();
        return d2;
    }

    public boolean inputCheck() {
        if (this.TOL <= 0.0) {
            this.solution.append("Tolerance must be positive \n");
            this.OK = false;
        }
        if (this.iterations <= 0) {
            this.solution.append("Number of Iterations must be positive \n");
            this.OK = false;
        }
        this.parseExpression();
        String string = this.myParser.getErrorInfo();
        if (string != null) {
            this.solution.append(string);
            this.OK = false;
        }
        return this.OK;
    }

    public double absVal(double d) {
        if (d >= 0.0) {
            return d;
        }
        return -d;
    }

    public void setVisualComponent() {
        this.startButton = new JButton("Start");
        this.initPoint = new JTextField(4);
        this.tTolerance = new JTextField(6);
        this.nIteration = new JTextField(2);
        this.exprField = new JTextField(20);
        this.solution = new JTextArea(17, 40);
        JScrollPane jScrollPane = new JScrollPane(this.solution);
        this.startButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(4, 6));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("Function g =:", 4));
        jPanel.add(this.exprField);
        this.exprField.setText("sqrt(10/(4+x))");
        jPanel.add(new JLabel("Point Po:", 4));
        jPanel.add(this.initPoint);
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("TOL:", 4));
        jPanel.add(this.tTolerance);
        jPanel.add(new JLabel("No Iterations:", 4));
        jPanel.add(this.nIteration);
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        jPanel.add(new JLabel("           ", 4));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 6));
        jPanel2.add(this.startButton);
        jPanel2.add(new JLabel("           ", 4));
        jPanel2.add(new JLabel("           ", 4));
        jPanel2.add(new JLabel("           ", 4));
        jPanel2.add(new JLabel("           ", 4));
        jPanel2.add(new JLabel("           ", 4));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel3);
        this.formatter = NumberFormat.getNumberInstance();
        this.formatter.setMaximumFractionDigits(9);
        this.formatter.setMinimumFractionDigits(9);
    }
}

