clear all

N=[5 10 20 30 40 50];
KA1=zeros(1,length(N));
KA2=zeros(1,length(N));

for h=1:length(N)
    n=N(h);
    x1=[0:n+1]/(n+1);
    x2=[0:2*n]/(2*n);
    E1=zeros(2*n+1,1);
    E2=zeros(2*n+1,1);
    % save all kind of entry 
    for k=1:2*n+1
        E1(k)=sum(x1.^(k-1));
        E2(k)=sum(x2.^(k-1));
    end
    % input A1,A1 is the case of m = n+1
    A1=zeros(n+1,n+1);
    for i=1:n+1
        for j=1:n+1
            A1(i,j)=E1(i+j-1);
        end
    end
    % input A2,A2 is the case of m = 2*n
    A2=zeros(n+1,n+1);
    for i=1:n+1
        for j=1:n+1
            A2(i,j)=E2(i+j-1);
        end
    end 
    % compute condition number of A1 and A2
    KA1(h)=cond(A1);
    KA2(h)=cond(A2);
end

figure(1)
plot(N,KA1);
title('HW14-2-condition number of matrix A_{n+1}')
xlabel('N')
ylabel('K ( A_{n+1} )')

figure(2)
plot(N,KA2);
title('HW14-2-condition number of matrix A_{2n}')
xlabel('N')
ylabel('K (A_{2n} )')