clear all
exact_value=cos(0)-cos(1);
% The standard indexing:
% partitioning nodes:  0=x_0, x_1, ... x_n=1.
% midpoints: x_{i-1/2}, i = 1,2, ..., n.
% The textbook uses slightly different indexing rule and
% the 'h' is also different by a factor of 2.
for n=[32 64 128]
    h=1/n;
    xc_h=0.5*h:h:1-0.5*h;
    y_h=sin(xc_h);
    midp_h = h*sum(y_h);
    
    hh=2*h;
    xc_2h=0.5*hh:hh:1-0.5*hh;
    y_2h=sin(xc_2h);
    midp_2h = hh*sum(y_2h);
 
    p1=log2((exact_value-midp_2h)/(exact_value-midp_h));
    fprintf('n = %4d , h= % 1.7f , p1 = %1.7f\n',n,h,p1)
end
