% The 2 dimension case
format long;
clear;
fprintf('In the 2D case, solve the linear system by SOR method.\n');
tic;
e1 = TwoD_Case(100,1.59);
t1 = toc;
fprintf('The error with N = 100 is %.8f. The computation takes %.0f seconds.\n',e1,t1);
tic;
e2 = TwoD_Case(200,1.69);
t2 = toc;
fprintf('The error with N = 200 is %.8f. The computation takes %.0f seconds.\n',e2,t2);
p = log2(e2/e1);
fprintf('The error of the numerical method is O(N^%.0f).\n',p);
fprintf('With an optimal parameter, the SOR method requires approximately O(N^4*logN) multiplications.\n');
r_analytic = ((200^4)*log(200))/((100^4)*log(100));
fprintf('The ratio of total multiplications with N = 200 and total multiplications with N = 100 is %.8f.\n',r_analytic);
r_numerical = t2/t1;
fprintf('The ratio of CPU time with N = 200 and CPU time with N = 100 is %.8f.\n',r_numerical);
if r_numerical < r_analytic
    fprintf('Since the numerical time cost is less than the analytic time cost (upper bound);\n');
    fprintf('Hence, we could conclude that the numerical method is well.\n\n');
else
    fprintf('Since the numerical time cost is exceed the analytic time cost (upper bound);\n');
    fprintf('Hence, we might conclude that the numerical method is not well.\n\n');
end