function error = OneD_Case(N)
    h = 1/N;
    nu = 0.1;
    x = [0:h:1]';
    % Initial value and boundary condition
    u = sin(pi*x);
    u(end) = 0;
    % Solve the linear system directly
    A0 = diag((h-nu)*ones(N-1,1),0)+diag(nu*(1/2)*ones(N-2,1),1)+diag(nu*(1/2)*ones(N-2,1),-1);
    A1 = diag((h+nu)*ones(N-1,1),0)+diag(nu*(-1/2)*ones(N-2,1),1)+diag(nu*(-1/2)*ones(N-2,1),-1);
    % Do LU factorization for matrix A1
    L = diag(ones(length(A1),1),0);
    U = zeros(length(A1));
    U(1,1) = A1(1,1);
    for i = 2:length(A1)
        U(i-1,i) = A1(i-1,i);
        L(i,i-1) = A1(i,i-1)/U(i-1,i-1);
        U(i,i) = A1(i,i)-L(i,i-1)*U(i-1,i);
    end
    % Solve for u from t = 1 to t = N
    for t = 1:N
        f = A0*u(2:end-1);
        g = zeros(length(L),1);
        z = zeros(length(U),1);
        % Solve Lg = f by forward substitution
        for i = 1:1:length(L)
            temp = 0;
            for j = 1:i-1
                temp = temp + L(i,j)*g(j);
            end
            g(i) = (f(i)-temp)/L(i,i);
        end
        % Solve Uz = g by forward substitution
        for i = length(U):-1:1
            temp = 0;
            for j = i+1:length(U)
                temp = temp + U(i,j)*z(j);
            end
           z(i) = (g(i)-temp)/U(i,i);
        end
        u(2:end-1) = z;
    end  
    % The exact solution
    ue = exp(-nu*pi^2)*sin(pi*x);
    % The error of approximation
    error = max(abs(ue(2:end-1)-u(2:end-1)));
end