% initial points x0 and x1
x0 = -1;
f0 = f(x0);

x1 = 0;
f1 = f(x1);

ep = 10^-6;            % the error tolerance
max_iterate = 10^6;    % the maximum of the iteration steps
error = 1;             % initial error

it_count=1; %it_count is the iteration steps, starting with 1

while ( error >= ep && it_count < max_iterate )
    it_count = it_count + 1;
    x2 = x1 - f1*(x1-x0)/(f1-f0);
    f2 = f(x2);
    error = abs(x2-x1);
    
    if sign(f1)*sign(f2) < 0    
        x0 = x1;
        f0 = f1;
    end
        x1 = x2;
        f1 = f2;
    
end

it_count
format long e
root1 = x2

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%      Another test, different x0 and x1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
% initial points x0 and x1
x0 = 0;
f0 = f(x0);

x1 = 1;
f1 = f(x1);

ep = 10^-6;            % the error tolerance
max_iterate = 10^4;    % the maximum of the iteration steps
error = 1;             % initial error

it_count=1; %it_count is the iteration steps, starting with 1

while ( error >= ep && it_count < max_iterate )
    it_count = it_count + 1;
    x2 = x1 - f1*(x1-x0)/(f1-f0);
    f2 = f(x2);
    error = abs(x2-x1);
    
    if sign(f1)*sign(f2) < 0    
        x0 = x1;
        f0 = f1;
    end
        x1 = x2;
        f1 = f2;
    
end

it_count
format long e
root2 = x2
