
//	module		: header file of linear equation 
//	file name	: cg_1d_array.h
//	version		: 1.0
//	author		: Lung Sheng Chien
//	date		: 2004 / 1 / 24
//  
//	description : 
//				A x = b  for poisson solver std stencil 
//	A (ei) denotes coefficient of i-th equation
//	A.coeff[0]  denotes coefficient of x(i)
//	A.coeff[1]  denotes coefficient of x(i-1)
//  A.coeff[2]  denotes coefficient of x(i+1)
//	ex.  Laplace u = f  over [0,1]  
//		( u(i-1) - 2u(i) + u(i+1) )/h^2 = f(i)		
//					| x(i-1) |
//		[ 1	-2 1 ]	| x(i)   |  = h^2 f(i)
//					| x(i+1) |
//
typedef struct linear_eqn
{
	double	coeff[3] ;	
}linear_eqn ;


int cg_1d_array(linear_eqn A[COL_DIM] , double x[COL_DIM] 
				 , double b[COL_DIM]  , double r[COL_DIM]  
				 , double v[COL_DIM]  , double z[COL_DIM]
				 , int imax , double eps , double delta ) ;

double inner_product(double x[COL_DIM], double y[COL_DIM] ) ;

void matrix_vector(linear_eqn A[COL_DIM], double x[COL_DIM], 
				   double y[COL_DIM] ) ;
