function z = Yvalue(xi,x,step,ycoeff)
%  Evaluate the quintic Hermite interpolants based on output from Rke.
%
%  Input arguments:
%    xi      = point at which evaluation is to be made.
%    x       = output from Rke (final value for independent variable).
%    step    = output from Rke (step taken).
%    ycoeff  = output from Rke (coefficients of quintics).
%
%  Output argument:
%    z       = column vector of solution components at xi.

%  Transform from [x - step,x] to [-0.5, 0.5], then evaluate.
arg = 0.5 + (xi - x) / step;
z = ycoeff(:,1) + arg * (ycoeff(:,2) + arg * (ycoeff(:,3) + ...
      arg * (ycoeff(:,4) + arg * (ycoeff(:,5) + arg * ycoeff(:,6)))));

