%  Example of the use of Zero. 
%  REQUIRES Zero.m and Xzerof.m.

global nfeval

%  Assign bracket and error tolerances.

b = 1;
c = 0;
abserr = 1e-8;
relerr = 1e-6;

nfeval = 0;   %  global variable to count function evaluations.

%  Use Zero to find a root.

[b,c,residual,flag] = Zero('Xzerof',b,c,abserr,relerr);

%  Check flag and print results.
fprintf('flag = %i \n',flag)
if     flag ==  0
  fprintf('Computed a root b = %e \n',b);
  fprintf('%i evaluations of f were required. \n',nfeval);
elseif flag ==  1
  fprintf('Too much work: nfeval = %i \n',nfeval);
  fprintf('There is a root in [b,c] with \n');
  fprintf('b = %e, c = %e \n',b,c);
elseif flag ==  2
  fprintf('Computed a pole b = %e \n',b);
end
fprintf('The residual f(b) = %e \n',residual);
