%  Example of interpolation with complete cubic spline.
%  REQUIRES Spcoef.m and Svalue.m.

%  Load the data arrays x and f.
n = 5;
x = linspace(0,0.8,n);
f = sin(x);
   
%  Calculate coefficients defining the complete cubic spline.

[b,c,d] = Spcoef(x,f);

%  Evaluate the spline at a few points.
m = 5;
t = zeros(m,1);
S = zeros(m,1);

interval = [];               % Initialize Svalue.
for i = 1:m
  t(i) = 0.1 + 0.2*(i-1); 
  [S(i),interval,flag] = Svalue(x,f,b,c,d,t(i),interval);
  fprintf('t = %3.1f    S = %7.5f    flag = %1i\n',t(i),S(i),flag);
end

%  Now compare the results in the span of the data to the function 
%  being interpolated.   

xplot = linspace(0,x(n),100);
plot(x,f,'*',t(1:m-1),S(1:m-1),'o',xplot,sin(xplot))
legend('data','interpolated values','sin(x)')
xlabel('x')

