%  Example of solution of a system of linear equations.
%  REQUIRES Factor.m and Solve.m.

%  Assign values to the entries of A.
A = [3  6   9
     2  5  -2
     1  3  -1];

%  Factor A and check its condition number.

[A,flag,pivot_index,Cond] = Factor(A);
if flag > 0
  fprintf('A has a zero pivot at %i\n',flag);
else
  fprintf('Cond = %e\n',Cond);

% Define the first right hand side vector B and solve the system.
  b = [39,3,2]';
  x = Solve(A,pivot_index,b);
  disp('Solution of the first system')
  disp(x')

% Define the second right hand side vector b and solve the system.
  b = [6,7,-12]';
  x = Solve(A,pivot_index,b);
  disp('Solution of the second system')
  disp(x')
end
