PROGRAM XLINSYS
!*********************************************************************
!   FUNCTION:  Example of solution of a system of linear equations.  *
!              f90 version.                                          *
!   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess       *
!              for the text  Fundamentals of Numerical Computing     *
!   DATE:      January, 1998                                         *
!*********************************************************************

  USE SAP_WP    ! Get working precision WP.
  USE SAP_CODES ! Get FACTOR and SOLVE subprograms.

  IMPLICIT NONE
  INTEGER, PARAMETER :: NEQ = 3
  INTEGER :: FLAG
  INTEGER, DIMENSION(NEQ) :: PIVOTS
  REAL (KIND = WP) :: COND
  REAL (KIND = WP), DIMENSION(NEQ,NEQ) :: A
  REAL (KIND = WP), DIMENSION(NEQ) :: B, X

  ! Assign values to the entries of A.
  A(1,:) = (/ 3.0_WP, 6.0_WP,  9.0_WP /)
  A(2,:) = (/ 2.0_WP, 5.0_WP, -2.0_WP /)
  A(3,:) = (/ 1.0_WP, 3.0_WP, -1.0_WP /)

  ! FACTOR A and check its condition number.
  CALL FACTOR(A,NEQ,FLAG,PIVOTS,COND)
  IF (FLAG < 0) THEN
    WRITE(*,*) 'NEQ <= 0 or A has fewer than NEQ rows and columns.'
    STOP
  ELSE IF (FLAG > 0) THEN
    WRITE(*,*) 'A has a zero pivot at',FLAG
    STOP
  END IF

  WRITE(*,*) 'COND =',COND

  !Define the first right hand side vector B and solve the system.
  B = (/ 39.0_WP, 3.0_WP, 2.0_WP /)
  X = SOLVE(A,NEQ,PIVOTS,B)
  WRITE(*,*) 'Solution of the first system:'
  WRITE(*,*) X

  !Define the second right hand side vector B and solve the system.
  B = (/ 6.0_WP, 7.0_WP, -12.0_WP /)
  X = SOLVE(A,NEQ,PIVOTS,B)
  WRITE(*,*) 'Solution of the second system:'
  WRITE(*,*) X
  STOP

END PROGRAM XLINSYS
