************************************************************************
*   FUNCTION:  Driver for using zero finding routines.                 *
*   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for    *
*              the text  Fundamentals of Numerical Computing           *
*   DATE:      June 12, 1995                                           *
************************************************************************
C     Sample program to illustrate ZERO.
C
      INTEGER          FLAG,NFEVAL
      DOUBLE PRECISION B,C,ABSERR,RELERR,F,RESIDL
C
C     Define labelled COMMON for the global variable NFEVAL.
C
      COMMON          /COST/ NFEVAL
      EXTERNAL         F
C
C     Assign bracket and error tolerances.
C
      B = 1.D0
      C = 0.D0
      ABSERR = 1.D-8
      RELERR = 1.D-6
C
C     Initialize the count of the number of calls to F from ZERO.
C
      NFEVAL = 0
C
C     Use ZERO to find a root.
C
      CALL ZERO(F,B,C,ABSERR,RELERR,RESIDL,FLAG)
C
C     Check FLAG and print results.
C
      IF (FLAG .EQ. -2) THEN
         PRINT *,' Initial interval [B,C] does not bracket a root.'
      ELSEIF (FLAG .EQ. -1) THEN
         PRINT *,' Error in specifying tolerances.'
      ELSEIF (FLAG .EQ. 0) THEN
         PRINT *,' Computed a root B = ',B
         PRINT *,' The residual F(B) = ',RESIDL
         PRINT *,NFEVAL,' evaluations of F were required.'
      ELSEIF (FLAG .EQ. 1) THEN
         PRINT *,' Too much work: NFEVAL = ',NFEVAL
         PRINT *,' There is a root in [B,C] with'
         PRINT *,' B = ',B,' C = ',C
         PRINT *,' The residual F(B)  = ',RESIDL
      ELSEIF (FLAG .EQ. 2) THEN
         PRINT *,' Computed a pole B = ',B
         PRINT *,' The residual F(B)  = ',RESIDL
      ENDIF
      STOP
      END
C-----------------------------------------------------------------------
      DOUBLE PRECISION FUNCTION F(X)
      DOUBLE PRECISION X
      INTEGER          NFEVAL
      COMMON          /COST/ NFEVAL
C
      F = EXP(-X) - 2.D0*X
      NFEVAL = NFEVAL+1
      RETURN
      END
