************************************************************************
*   FUNCTION:  Driver for using adaptive quadrature routines.          *
*   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for    *
*              the text  Fundamentals of Numerical Computing           *
*   DATE:      June 26, 1994                                           *
************************************************************************
C  Sample program for FACTOR/SOLVE.
C
      DOUBLE PRECISION A(10,10),B(10),TEMP(10),COND
      INTEGER FLAG,I,MAXROW,NEQ,PVTIDX(10)
C
C     Assign values for MAXROW, NEQ, and entries of A.
C
      MAXROW = 10
      NEQ = 3
      A(1,1) =  3.D0
      A(1,2) =  6.D0
      A(1,3) =  9.D0
      A(2,1) =  2.D0
      A(2,2) =  5.D0
      A(2,3) = -2.D0
      A(3,1) =  1.D0
      A(3,2) =  3.D0
      A(3,3) = -1.D0
C
C     Factor A and check its condition number.
C
      CALL FACTOR(A,MAXROW,NEQ,COND,PVTIDX,FLAG,TEMP)
      PRINT *,' Condition number = ',COND
      IF (FLAG .LT. 0) THEN
         PRINT *,' Illegal input: check MAXROW and NEQ.'
         STOP
      ENDIF
      IF (FLAG .GT. 0) THEN
         PRINT *,' Coefficient matrix has a zero pivot at ',FLAG
         STOP
      ENDIF
C
C     Define the first right hand side vector B and solve the system.
C
      B(1) = 39.D0
      B(2) =  3.D0
      B(3) =  2.D0
      CALL SOLVE(A,MAXROW,NEQ,PVTIDX,B)
      PRINT *,' Solution vector for the first system:'
      PRINT *,(B(I),I = 1,NEQ)
C
C     Define the second right hand side vector B and solve the system.
C
      B(1) =   6.D0
      B(2) =   7.D0
      B(3) = -12.D0
      CALL SOLVE(A,MAXROW,NEQ,PVTIDX,B)
      PRINT *,' Solution vector for the second system:'
      PRINT *,(B(I),I = 1,NEQ)
      STOP
      END
C=======================================================================