************************************************************************
*   FUNCTION:  Sample driver for functions Rke and Yvalue.             *
*   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for    *
*              the text  Fundamentals of Numerical Computing           *
*   DATE:      May 12, 1995                                            *
*   PURPOSE:   Solve Van der Pol's equation on the interval [0,10]     *
*              producing answers at x = 1,2,3,...                      *
************************************************************************
C  Sample program to illustrate RKE and YVALUE; solves Van der Pol's 
C  equation on the interval [0,10] producing answers at X = 1,2,3,...
C
      DOUBLE PRECISION X,Y(2),H,TOL,THRES(2),STEP,YCOEFF(12),
     &   SCR(12),XOUT(11),Z(2)
      INTEGER FLAG,I,NDIM,NEQ,NOUT
      LOGICAL FIRST
      EXTERNAL F
C
C     Set initial values and tolerances.
C
      NEQ = 2
      Y(1) = 1.D0
      Y(2) = 1.D0
      H = 0.1D0
      TOL = 1.D-5
      THRES(1) = 1.D-5
      THRES(2) = 1.D-5
      FIRST = .TRUE.
      NDIM = 12
C
C     Define solution output points.
C
      NOUT = 11
      DO 10 I = 1,NOUT
         XOUT(I) = I-1
   10 CONTINUE
C
C     Integration loop: call RKE and YVALUE as necessary.
C     H > 0 is assumed.
C
      X = XOUT(1)
      DO 40 I = 1,NOUT
  20     IF (X .LE. XOUT(I)) THEN
            CALL RKE(F,NEQ,X,Y,H,FIRST,TOL,THRES,FLAG,STEP,YCOEFF,
     &               SCR,NDIM)
            IF (FLAG .NE. 0) THEN
               PRINT *,' Error at X =',X,'; FLAG =',FLAG
               STOP
            ENDIF
            GOTO 20
         ENDIF
         CALL YVALUE(NEQ,X,STEP,YCOEFF,XOUT(I),Z)
         WRITE (*,30) XOUT(I),Z(1),Z(2)
   30    FORMAT (' XOUT =',F5.2,'    Y(1) =',F9.6,'    Y(2) =',F9.6)
   40 CONTINUE
      STOP
      END
C-----------------------------------------------------------------------
      SUBROUTINE F(X,Y,YPRIME)
      DOUBLE PRECISION X,Y(*),YPRIME(*)
      YPRIME(1) =  Y(2)
      YPRIME(2) = -Y(1)-(Y(1)**2-1.D0)*Y(2)
      RETURN
      END
C=======================================================================