************************************************************************
*   FUNCTION:  Sample driver for function Rke.                         *
*   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for    *
*              the text  Fundamentals of Numerical Computing           *
*   DATE:      January 9, 1995                                         *
*   PURPOSE:   Demonstrate a simple use of Rke.                        *
************************************************************************
C     Sample program to illustrate RKE.
C
      DOUBLE PRECISION X,Y(2),H,TOL,THRES(2),STEP,YCOEFF(12),
     &   SCR(12),XOUT
      INTEGER FLAG,NDIM,NEQ
      LOGICAL FIRST
      EXTERNAL F
C
C     Set initial values and tolerances.
C
      NEQ = 2
      X = 0.D0
      Y(1) = 1.D0
      Y(2) = 1.D0
      XOUT = 1.D0
      H = 0.1D0
      TOL = 1.D-5
      THRES(1) = 0.D0
      THRES(2) = 1.D-5
      FIRST = .TRUE.
      NDIM = 12
C
C     Integration loop: call RKE repeatedly until XOUT is reached.
C     H > 0 is assumed.
C
   10 IF (X+H .GT. XOUT) H = XOUT-X
         CALL RKE(F,NEQ,X,Y,H,FIRST,TOL,THRES,FLAG,STEP,YCOEFF,SCR,NDIM)
         IF (FLAG .NE. 0) THEN
            PRINT *,' FLAG =',FLAG,' at X =',X
            STOP
         ENDIF
         IF (X .LT. XOUT) GOTO 10
C
C     Print the results.
C
      PRINT *,' At XOUT = ',XOUT
      PRINT *,' The numerical solution is ',Y(1),Y(2)
      PRINT *,' The true solution is      ',EXP(XOUT),EXP(-XOUT)
      STOP
      END
C-----------------------------------------------------------------------
      SUBROUTINE F(X,Y,YPRIME)
      DOUBLE PRECISION X,Y(*),YPRIME(*)
      YPRIME(1) =  Y(1)
      YPRIME(2) = -Y(2)
      RETURN
      END
C=======================================================================
