// FUNCTION:  Driver for using zero finding routines.
// AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
//            the text Fundamentals of Numerical Computing
// DATE:      August 25, 1995

#include "fnc.h"

#include <iostream.h>
#include <iomanip.h>
#include <math.h>

//  Give prototype for function whose zero is sought.

double f(double);

//  Declare global variables to be passed around Zero.  In this example, 
//  num_f_evals is used to count the number of evaluations of f by Zero.

int num_f_evals;

void main()
{
    int flag;
    double b, c, abserr, relerr, residual;

//  Set output formatting.

    cout.setf(ios::scientific);     // Use scientific notation.
    cout.precision(15);             // Show all digits.

//  Assign bracket and error tolerances.

    b = 1.0;
    c = 0.0;
    abserr = 1.e-8;
    relerr = 1.e-6;

//  Initialize the count of the number of F evaluations.

    num_f_evals = 0;

//  Use Zero to find a root.

    flag = Zero(f, b, c, abserr, relerr, residual);

//  Check flag and print results.

    switch (flag)
    {
       case  -2:
          cout << "Flag = -2 \n" <<
                  "Initial interval [b,c] does not bracket a root.\n";
          break;
       case  -1:
          cout << "Flag = -1 \n" << "Error in specifying tolerances. \n";
          break;
       case   1:
          cout << "Flag =  1 \n" << "Too much work: num_f_evals = "
               << num_f_evals << endl << "There is a root in [b,c] with \n"
               << " b = " << setw(22) << b << " c = " << setw(22) << c << endl
               << "The residual f(b) = " << setw(22) << residual << endl;
          break;
       case   2:
          cout << "Flag =  2 \n" << "Computed a pole b = " << setw(22)
               << b << endl << "The residual f(b) = " << setw(22) 
               << residual << endl;
          break;
       default:         //   flag = 0 
         cout << "Flag =  0 \n" << "Computed a root b = " << setw(22) 
              << b << endl << "The residual f(b) = " << setw(22) 
              << residual << endl << setw(11) << num_f_evals 
              << " evaluations of f were required. \n";
         break;
    }
}

double f(double x)
{
    num_f_evals++;
    return exp(-x) - 2.0 * x;
}
