// FUNCTION:  Driver for using cubic interpolatory spline routines.
// AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
//            the text  Fundamentals of Numerical Computing
// DATE:      February 24, 1996

#include "fnc.h"

#include <iostream.h>
#include <iomanip.h>
#include <math.h>

void main()
{
    int flag, i, interval, n;
    double b[11], c[11], d[11], f[11], x[11], s, t;

//  Set output formatting.

    cout.setf(ios::scientific);   // Use scientific notation.
    cout.precision(15);           // Show all digits.

//  Assign values for n and the data arrays x and f (start indexing at 1
//  as in the text).

    n = 5;
    for (i = 0; i < n; i++)
    {
        x[i] = 0.20 * i;
        f[i] = sin(x[i]);
    }

//  Calculate coefficients defining the cubic spline.

    flag = Spline_coeff(n, x, f, b, c, d);

//  Check flag, calculate spline values at a few points and
//  print the results.

    if (flag != 0)
       cout << "Error in data, flag = " << flag << endl;
    else
    {
       for (i = 0; i < 5; i++)
       {
           t = 0.10 + 0.20 * i;
           flag = Spline_value(n, x, f, b, c, d, t, interval, s);
           cout << "t = " << setw(18) << t << "   s = " << setw(18)
                << s << "   flag = " << flag << endl;
       }
   }
   cout << endl;
}
