/* FUNCTION:  Driver for using adaptive quadrature routines.
   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
              the text  Fundamentals of Numerical Computing
   DATE:      August 25, 1995                           */

#include "fnc.h"

#include <math.h>       /*   for exp   */
#include <stdio.h>      /*   for printf   */

/*      Declare the prototype for the integrand.         */
double f( );

/*      Declare the global variable n_func.              */
int num_f_evals;

void main()
{
   double a, b, abserr, relerr, answer, errest;
   int flag;
/*
   Assign limits of integration and error tolerances.
*/
   a = 0.0;
   b = 1.0;
   abserr = 1.e-5;
   relerr = 1.e-8;
/*
   Use num_f_evals to count the number of f evaluations by Adapt.
*/
   num_f_evals = 0;
/*
   Use Adapt to estimate integral of the function defined by f.
*/
   flag = Adapt(f, a, b, abserr, relerr, &answer, &errest);
/*
   Check flag and print the results.
*/
   if (flag == -1)
      printf("\n Invalid input parameters");
   else
   {
      printf("\n Flag = %i",flag);
      printf("\n Approximate value of the integral = %19.15f",answer);
      printf("\n Error in answer is approximately %24.15e",errest);
      printf("\n %11.1i integrand evaluations were required.\n",num_f_evals);
   }
}

double f(x)
   double x;
{
   num_f_evals++;
   return exp(x);
}
