/* FUNCTION:  Sample driver for functions Rke and Yvalue.
   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
              the text  Fundamentals of Numerical Computing
   DATE:      August 25, 1995
   PURPOSE:   Solve Van der Pol's equation on the interval [0,10] 
              producing answers at x = 1,2,3,...                  */

#include "fnc.h"

#include <stdlib.h>   /*   for malloc   */
#include <stdio.h>    /*   for printf   */

/*     Declare prototype for the function describing the ODEs.    */
void f( );

void main()
{
    double x, y[2], h, tol, threshold[2], step, *ycoeff, xout[11], z[2];
    int first, flag, i, ndim, neq, nout;
    static int true = 1, false = 0;
/*
    Set initial values and tolerances.
*/
    neq = 2;
    y[0] = 1.0;
    y[1] = 1.0;
    h = 0.1;
    tol = 1.e-5;
    threshold[0] = 1.e-5;
    threshold[1] = 1.e-5;
    first = true;
/*
    Allocate storage for ycoeff.
*/
    ycoeff = (double*) malloc(6*neq*sizeof(double));
/*
    Define the solution output points.
*/
    nout = 11;
    for (i = 0; i < nout; i++) xout[i] = i;
/*
    Integration loop: call Rke and Yvalue as necessary; h > 0 is assumed.
*/
    x = xout[0];
    for (i = 0; i < nout; i++)
    {
       while (x <= xout[i])
       {
          Rke(f, neq, &x, y, &h, &first, tol, threshold, &flag,
              &step, ycoeff);
          if (flag != 0)
          {
             printf("Error at x = %12.8e ; flag = %i\n",x,flag);
             return;
          }
       }
       Yvalue(neq, x, step, ycoeff, xout[i], z);
       printf("Xout = %5.2f ; Y(1) = %9.6f, Y(2) = %9.6f\n",xout[i],
              z[0],z[1]);
    }
    printf("\n");
}
/* -------------------------------------------------------------------- */
void f(x, y, yprime)
    double x, y[], yprime[];
{
    yprime[0] =  y[1];
    yprime[1] = -y[0]-(y[0]*y[0]-1.0)*y[1];
    return;
}
