/* FUNCTION:  Sample driver for function Rke.
   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
              the text  Fundamentals of Numerical Computing
   DATE:      August 25, 1995
   PURPOSE:   Demonstrate a simple use of Rke.                    */

#include "fnc.h"

#include <math.h>     /*   for exp   */
#include <stdio.h>    /*   for printf   */

/*     Declare prototype for the function describing the ODEs.    */
void f( );

void main()
{
    double x, y[2], h, tol, threshold[2], step, ycoeff[12], xout;
    int first, flag, ndim, neq;
    static int true = 1, false = 0;
/*
    Set initial values and tolerances.
*/
    neq = 2;
    x = 0.0;
    y[0] = 1.0;
    y[1] = 1.0;
    xout = 1.0;
    h = 0.1;
    tol = 1.e-5;
    threshold[0] = 0.0;
    threshold[1] = 1.e-5;
    first = true;
/*
    Integration loop: call Rke repeatedly until xout is reached;
    h > 0 is assumed.
*/
    while (x < xout)
    {
       if (x+h > xout) h = xout-x;
       Rke(f, neq, &x, y, &h, &first, tol, threshold, &flag,
           &step, ycoeff);
       if (flag != 0)
       {
          printf(" flag = %i,' at x = %22.15f\n",flag,x);
          return;
       }
    }
/*
    Print the results.
*/
    printf(" At xout = %18.15f\n",xout);
    printf(" The numerical solution is %22.15f %22.15f\n",y[0],y[1]);
    printf(" The true solution is      %22.15f %22.15f\n",
           exp(xout),exp(-xout));
    return;
}
/* ------------------------------------------------------------------- */
void f(x, y, yprime)
    double x, y[], yprime[];
{
    yprime[0] =  y[0];
    yprime[1] = -y[1];
    return;
}
