/* FUNCTION:  This is the header file for the C codes accompanying
              the text  Fundamentals of Numerical Computing.
   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess
   DATE:      August 25, 1995                                   */

/*      Declare the functions defined in "fnc_util.c".          */

extern double abs_d();
extern double max_d();
extern double min_d();
extern double sign();

/*    Declare the structure used in Adapt.     */

#ifndef QUADNODE_H
#define QUADNODE_H
struct QuadNode
{
    double Q;
    double E;
    double alpha;
    double beta;
    struct QuadNode* Next;
};
#endif

/*      Declare the library functions.                      */

extern int Factor();
extern void Solve();

extern int Spline_coeff();
extern int Spline_value();

extern int Zero();

extern int Adapt();
extern int Add();
extern void Remove();
extern void Quad();
extern int Empty();

extern void Rke();
extern void Yvalue();
extern void England();
