!     Last change:  LFS  26 Dec 97    9:51 am
PROGRAM X2RKE
!**********************************************************************
!   FUNCTION:  Example of the solution of a system of ordinary        *
!              differential equations, including interpolation.       *
!              f90 version.                                           *
!   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess        *
!              for the text  Fundamentals of Numerical Computing      *
!   DATE:      January, 1998                                          *
!**********************************************************************

  USE SAP_WP    ! Get working precision WP.
  USE SAP_CODES ! Get RKE and YVALUE subprograms.

  IMPLICIT NONE
  INTEGER, PARAMETER :: NEQ = 2, NOUT = 11
  REAL (KIND = WP) :: Y(NEQ), YP(NEQ), THRESHOLD(NEQ), Z(NEQ), &
                      YCOEFF(NEQ,6), XOUT(NOUT)
  INTEGER :: I, NASTEPS, FLAG
  REAL (KIND = WP) :: X, H, TOL, STEP
  INTERFACE
    FUNCTION F(X,Y) RESULT(YPRIME)
     USE SAP_WP  ! Get working precision WP.
     IMPLICIT NONE
     REAL (KIND = WP), INTENT(IN) :: X
     REAL (KIND = WP), DIMENSION(:), INTENT(IN) :: Y
     REAL (KIND = WP), DIMENSION(SIZE(Y)) :: YPRIME
    END FUNCTION F
  END INTERFACE

  ! Set initial values and tolerances.  NEQ has been set as a parameter.
  Y(1) = 1.0_WP
  Y(2) = 1.0_WP
  H = 0.1_WP
  TOL = 1E-5_WP
  THRESHOLD = 1E-5_WP

  ! Define the solution output points. NOUT has been set as a parameter.
  XOUT = (/ (I, I = 0,NOUT-1) /)

  ! Integration loop.  RKE chooses the step size for efficiency.  YVALUE
  ! is used to get output by interpolation each time that RKE steps past
  ! an output point XOUT(I), including the initial point.

  X = XOUT(1)
  NASTEPS = 0                     ! Initialize RKE.
  YP = 0.0_WP
  DO I = 1,NOUT
    DO WHILE (X <= XOUT(I))
      CALL RKE(F,NEQ,X,Y,YP,H,TOL,THRESHOLD,NASTEPS,FLAG,STEP,YCOEFF)
      IF (FLAG /= 0) THEN
        WRITE(*,*)' FLAG =',FLAG,' at X =',X
        STOP
      END IF
    END DO
    Z = YVALUE(XOUT(I),X,STEP,YCOEFF)
    WRITE (*,"(' XOUT =',F5.2,'    Y(1) =',F9.6,'    Y(2) =',F9.6)") XOUT(I),Z(1),Z(2)
  END DO
  STOP
      
END PROGRAM X2RKE

FUNCTION F(X,Y) RESULT(YPRIME)
    
  USE SAP_WP  ! Get working precision WP.
  
  IMPLICIT NONE
  REAL (KIND = WP), INTENT(IN) :: X
  REAL (KIND = WP), DIMENSION(:), INTENT(IN) :: Y
  REAL (KIND = WP), DIMENSION(SIZE(Y)) :: YPRIME

  ! Not using all arguments in a subprogram is a fatal error with the ELF90
  ! compiler, so in the next equation, X is used in a way that has no effect.
  YPRIME(1) =  Y(2) + 0.0_WP*X
  YPRIME(2) = -Y(1) - (Y(1)**2 - 1.0_WP)*Y(2)
  RETURN

END FUNCTION F

