// FUNCTION:  Sample driver for function Rke.
// AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
//            the text  Fundamentals of Numerical Computing
// DATE:      December 6, 1995
// PURPOSE:   Demonstrate a simple use of Rke.

#include "fnc.h"

#include <iostream.h>
#include <iomanip.h>
#include <math.h>

//   Declare prototype for the function describing the ODEs.

void f(double, double[], double[]);

void main()
{
    double x, y[2], h, tol, threshold[2], step, ycoeff[12], xout;
    int first, flag, neq;
    const int true = 1, false = 0;

//  Set output formatting.

    cout.setf(ios::fixed | ios::showpoint);  // Use fixed point, show decimal.
    cout.precision(15);                      // Show all digits.

//  Set initial values and tolerances.

    neq = 2;
    x = 0.0;
    y[0] = 1.0;
    y[1] = 1.0;
    xout = 1.0;
    h = 0.1;
    tol = 1.e-5;
    threshold[0] = 0.0;
    threshold[1] = 1.e-5;
    first = true;

//  Integration loop: call Rke repeatedly until xout is reached;
//  h > 0 is assumed.

    while (x < xout)
    {
          if (x + h > xout) h = xout - x;
          Rke(f, neq, x, y, h, first, tol, threshold, flag, step, ycoeff);
          if (flag != 0)
          {
             cout << "\n flag = " << flag << " at x = "  << setw(22) 
                  << x << endl;
             return;
          }
    }

//  Print the results.

    cout << "\n At xout = " <<  setw(18) << xout << endl
         << " The numerical solution is " << setw(22) << y[0] << "   "
         << y[1] << endl << " The true solution is           " << exp(xout)
         << "   " << exp(-xout) << endl;
    return;
}
///////////////////////////////////////////////////////////////////////////////
void f(double x, double y[], double yprime[])
{
    yprime[0] =  y[0];
    yprime[1] = -y[1];
    return;
}
