PROGRAM XSPLINE
!*********************************************************************
!   FUNCTION:  Example of interpolation with complete cubic spline.  *
!              f90 version.                                          *
!   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess       *
!              for the text  Fundamentals of Numerical Computing     *
!   DATE:      January, 1998                                         *
!*********************************************************************

  USE SAP_WP    ! Get working precision WP.
  USE SAP_CODES ! Get SPCOEF and SVALUE subprograms.

  IMPLICIT NONE
  INTEGER, PARAMETER :: N = 5
  INTEGER :: FLAG, I
  REAL (KIND = WP) :: S, T
  REAL (KIND = WP), DIMENSION(N) :: X, F, B, C, D

  ! Assign values to the data arrays X and F.
  X = (/ (I*0.2_WP, I=0,N-1) /)
  F = SIN(X)

  ! Calculate coefficients defining the complete cubic spline.
  CALL SPCOEF(N,X,F,B,C,D,FLAG)
  IF (FLAG /= 0) THEN
    WRITE(*,*) 'Input error: FLAG =',FLAG
    STOP
  END IF

  ! Evaluate the spline at a few points.
  DO I = 1,5
    T = 0.1_WP + 0.2_WP*(I-1)
    CALL SVALUE(X,F,B,C,D,T,FLAG,S)
    WRITE(*,*) ' T =',T,'  S =',S,'  FLAG =',FLAG
  END DO
  STOP

END PROGRAM XSPLINE

