// FUNCTION:  Sample driver for functions Factor and Solve.
// AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
//            the text  Fundamentals of Numerical Computing
// DATE:      December 6, 1995

#include "fnc.h"

#include <iostream.h>
#include <iomanip.h>

void main()
{
    double **a, *b, cond;
    int flag, i, neq, *pivot_index;

//  Set output formatting.

    cout.setf(ios::fixed | ios::showpoint);  // Use fixed point, show decimal.
    cout.precision(15);                      // Show all digits.

//  Allocate storage for pointer to rows of A, matrix A, right-hand side b,
//  and index vector pivot_index.  We assume the allocation is successful.

    neq = 3;
    a = new double*[neq];
    for (i = 0; i < neq; i++) a[i] = new double[neq];
    b = new double[neq];
    pivot_index = new int[neq];

//  Assign values to the entries of A.

    a[0][0] =  3.0;
    a[0][1] =  6.0;
    a[0][2] =  9.0;
    a[1][0] =  2.0;
    a[1][1] =  5.0;
    a[1][2] = -2.0;
    a[2][0] =  1.0;
    a[2][1] =  3.0;
    a[2][2] = -1.0;

//  Factor A and check its condition number.

    flag = Factor(a, neq, cond, pivot_index);
    cout << "Condition number = " << setw(22) << cond << endl;
    
    if (flag == -2)
       cout << "Insufficient memory for allocation in function linsys." 
            << endl;
    if (flag == -1)
       cout << "Illegal input: check max_column_index and neq.\n";
    if (flag > 0)
       cout << "Coefficient matrix has a zero pivot at " << flag << endl;
    else
    {

//     Define the first right hand side vector B and solve the system.

       b[0] = 39.0;
       b[1] =  3.0;
       b[2] =  2.0;
       Solve(a, neq, pivot_index, b);
       cout << endl << "Solution vector for the first system" << endl;
       for (i = 0; i < neq; i++)
           cout << setw(22) << b[i];

//     Define the second right hand side vector b and solve the system.

       b[0] =   6.0;
       b[1] =   7.0;
       b[2] = -12.0;
       Solve(a, neq, pivot_index, b);
       cout << endl << "Solution vector for the second system" << endl;
       for (i = 0; i < neq; i++)
           cout << setw(22) << b[i];
    }
    cout << endl;
    delete [] pivot_index;
    delete [] b;
    delete [] a;
}
