/* FUNCTION:  Sample driver for functions Factor and Solve.
   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess  for
              the text  Fundamentals of Numerical Computing
   DATE:      August 25, 1995                                         */

#include "fnc.h"

#include <stdio.h>     /*   for printf   */
#include <stdlib.h>    /*   for malloc   */

void main()
{
   double **a, *b, cond;
   int flag, i, neq, *pivot_index;
/*
   Allocate storage for pointer to rows of A, matrix A, right-hand side b,
   and index vector pivot_index.  We assume the allocation is successful.
*/
   neq = 3;
   a = (double**) malloc(neq*sizeof(double*));
   for (i = 0; i < neq; i++) a[i] = (double*) malloc(neq*sizeof(double));
   b = (double*) malloc(neq*sizeof(double));
   pivot_index = (int*) malloc(neq*sizeof(int));
/*
   Assign values to the entries of A.
*/
   a[0][0] =  3.0;
   a[0][1] =  6.0;
   a[0][2] =  9.0;
   a[1][0] =  2.0;
   a[1][1] =  5.0;
   a[1][2] = -2.0;
   a[2][0] =  1.0;
   a[2][1] =  3.0;
   a[2][2] = -1.0;
/*
   Factor A and check its condition number.
*/
   flag = Factor(a, neq, &cond, pivot_index);
   printf("\n Condition number = %22.15f",cond);
   if (flag == -2)
      printf("\nInsufficient memory for allocation in function linsys.");
   if (flag == -1)
      printf("\nIllegal input: check max_column_index and neq.");
   if (flag > 0)
      printf("\nCoefficient matrix has a zero pivot at %i",flag);
   else
   {
/*
      Define the first right hand side vector B and solve the system.
*/
      b[0] = 39.0;
      b[1] =  3.0;
      b[2] =  2.0;
      Solve(a, neq, pivot_index, b);
      printf("\n Solution vector for the first system\n");
      for (i = 0; i < neq; i++) printf("%22.15f",b[i]);
/*
      Define the second right hand side vector b and solve the system.
*/
      b[0] =   6.0;
      b[1] =   7.0;
      b[2] = -12.0;
      Solve(a, neq, pivot_index, b);
      printf("\n Solution vector for the second system\n");
      for (i = 0; i < neq; i++) printf("%22.15f",b[i]);
   }
   printf("\n");
   free(pivot_index);
   free(b);
   free(a);
}
