MODULE COUNTER
! Count function evaluations with NFEVAL.

  IMPLICIT NONE
  INTEGER :: NFEVAL

END MODULE COUNTER

PROGRAM XZERO
!*********************************************************************
!   FUNCTION:  Example of finding a zero of a function. f90 version. *
!   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess       *
!              for the text  Fundamentals of Numerical Computing     *
!   DATE:      January, 1998                                         *
!*********************************************************************

  USE COUNTER   ! Count function evaluations with NFEVAL.
  USE SAP_WP    ! Get working precision WP.
  USE SAP_CODES ! Get ZERO subroutine.

  IMPLICIT NONE
  INTEGER :: FLAG
  REAL (KIND = WP) :: B, C, ABSERR, RELERR, RESIDUAL
  INTERFACE
    FUNCTION F(X)
      USE SAP_WP
      IMPLICIT NONE
      REAL (KIND = WP), INTENT(IN) :: X
      REAL (KIND = WP) :: F
    END FUNCTION F
  END INTERFACE

  ! Assign bracket and error tolerances.
  B = 1.0_WP
  C = 0.0_WP
  ABSERR = 1E-8_WP
  RELERR = 1E-6_WP

  ! Initialize the count of the number of calls to F from ZERO.
  NFEVAL = 0

  ! Use ZERO to find a root.
  CALL ZERO(F,B,C,ABSERR,RELERR,RESIDUAL,FLAG)
  
  ! Check FLAG and display results.
  IF      (FLAG == -2) THEN
    WRITE(*,*) ' Initial interval [B,C] does not bracket a root.'
  ELSE IF (FLAG == -1) THEN
    WRITE(*,*) ' Error in specifying tolerances.'
  ELSE IF (FLAG == 0) THEN
    WRITE(*,*) ' Computed a root B = ',B
    WRITE(*,*) ' The residual F(B) = ',RESIDUAL
    WRITE(*,*) NFEVAL,' evaluations of F were required.'
  ELSE IF (FLAG == 1) THEN
    WRITE(*,*) ' Too much work: NFEVAL = ',NFEVAL
    WRITE(*,*) ' There is a root in [B,C] with'
    WRITE(*,*) ' B = ',B,' C = ',C
    WRITE(*,*) ' The residual F(B)  = ',RESIDUAL
  ELSE IF (FLAG == 2) THEN
    WRITE(*,*) ' Computed a pole B = ',B
    WRITE(*,*) ' The residual F(B)  = ',RESIDUAL
  END IF
  
  STOP
      
END PROGRAM XZERO

FUNCTION F(X)
  
  USE COUNTER ! Count function evaluations with NFEVAL.
  USE SAP_WP  ! Get working precision WP.

  IMPLICIT NONE
  REAL (KIND = WP), INTENT(IN) :: X
  REAL (KIND = WP) :: F 
  
  F = EXP(-X) - 2.0_WP*X
  NFEVAL = NFEVAL + 1
  RETURN

END FUNCTION F
