MODULE COUNTER
! Count function evaluations with NFEVAL.

  IMPLICIT NONE
  INTEGER :: NFEVAL

END MODULE COUNTER


PROGRAM XADAPT
!*********************************************************************
!   FUNCTION:  Example of computing a definite integral.             *
!              f90 version.                                          *
!   AUTHORS:   Lawrence Shampine, Richard Allen, Steven Pruess       *
!              for the text  Fundamentals of Numerical Computing     *
!   DATE:      January, 1998                                         *
!*********************************************************************

  USE COUNTER   ! Count function evaluations with NFEVAL.
  USE SAP_WP    ! Get working precision WP.
  USE SAP_CODES ! Get ADAPT subroutine.

  IMPLICIT NONE
  INTEGER :: FLAG
  REAL (KIND = WP) :: A, B, ABSERR, RELERR, ANSWER, ERREST
  INTERFACE
    FUNCTION F(X)
      USE SAP_WP
      IMPLICIT NONE
      REAL (KIND = WP), INTENT(IN) :: X
      REAL (KIND = WP) :: F
    END FUNCTION F
  END INTERFACE

  ! Assign limits of integration and error tolerances.
  A = 0.0_WP
  B = 1.0_WP
  ABSERR = 1E-5_WP
  RELERR = 1E-8_WP

  ! Initialize the count of the number of calls to F from ADAPT.
  NFEVAL = 0

  ! Use ADAPT to estimate integral of the function defined by F.
  CALL ADAPT(F,A,B,ABSERR,RELERR,ANSWER,ERREST,FLAG)

  ! Check FLAG and display results.
  IF (FLAG == -1) THEN
    WRITE(*,*) ' Invalid input parameters'
  ELSE
    WRITE(*,*) ' FLAG =',FLAG
    WRITE(*,*) ' Approximate value of the integral =',ANSWER
    WRITE(*,*) ' Error in ANSWER is approximately   ',ERREST
    WRITE(*,*) NFEVAL,' integrand evaluations were required.'
  END IF

  STOP

END PROGRAM XADAPT


FUNCTION F(X) 

  USE COUNTER ! Count function evaluations with NFEVAL.
  USE SAP_WP  ! Get working precision WP.

  IMPLICIT NONE
  REAL (KIND = WP), INTENT(IN) :: X
  REAL (KIND = WP) :: F
    
  F = EXP(X)
  NFEVAL = NFEVAL + 1
  RETURN

END FUNCTION F

